/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.chunkbounds;

import at.ridgo8.moreoverlays.chunkbounds.ChunkBoundsRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ChunkBoundsHandler {
    public static final int REGION_SIZEX = 32;
    public static final int REGION_SIZEZ = 32;
    public static final int REGION_SIZEY_CUBIC = 32;
    private static RenderMode mode = RenderMode.NONE;
    private final List<String> regionInfo = new ArrayList<String>();
    private int playerPrevRegionPosX = Integer.MIN_VALUE;
    private int playerPrevRegionPosZ = Integer.MIN_VALUE;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new ChunkBoundsHandler());
    }

    public static RenderMode getMode() {
        return mode;
    }

    public static void setMode(RenderMode mode) {
        ChunkBoundsHandler.mode = mode;
    }

    public static void toggleMode() {
        RenderMode[] modes = RenderMode.values();
        mode = modes[(mode.ordinal() + 1) % modes.length];
        Minecraft.getInstance().player.displayClientMessage(Component.nullToEmpty((String)(String.valueOf(ChatFormatting.RED) + "Chunk Border Overlay: " + mode.name())), true);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderLevelStageEvent event) {
        if (!event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            return;
        }
        if (mode != RenderMode.NONE) {
            ChunkBoundsRenderer.renderOverlays(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiEvent.Post event) {
        if (this.regionInfo.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.getDebugOverlay().showDebugScreen()) {
            return;
        }
        int y = 0;
        for (String text : this.regionInfo) {
            event.getGuiGraphics().drawString(mc.font, text, 10, y += 10, 0xFFFFFF);
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        int newRegionZ;
        int newRegionX;
        Minecraft instance = Minecraft.getInstance();
        if (instance.player == null) {
            return;
        }
        if (ChunkBoundsHandler.getMode() != RenderMode.REGIONS) {
            this.regionInfo.clear();
            this.playerPrevRegionPosX = 0;
            this.playerPrevRegionPosZ = 0;
            return;
        }
        LocalPlayer player = instance.player;
        boolean updateInfo = this.regionInfo.isEmpty();
        if (player.chunkPosition().x < 0) {
            newRegionX = (player.chunkPosition().x + 1) / 32;
            --newRegionX;
        } else {
            newRegionX = player.chunkPosition().x / 32;
        }
        if (this.playerPrevRegionPosX != newRegionX) {
            this.playerPrevRegionPosX = newRegionX;
            updateInfo = true;
        }
        if (player.chunkPosition().z < 0) {
            newRegionZ = (player.chunkPosition().z + 1) / 32;
            --newRegionZ;
        } else {
            newRegionZ = player.chunkPosition().z / 32;
        }
        if (this.playerPrevRegionPosZ != newRegionZ) {
            this.playerPrevRegionPosZ = newRegionZ;
            updateInfo = true;
        }
        if (updateInfo) {
            this.regionInfo.clear();
            this.regionInfo.add(String.format("region/r.%d.%d.mca", this.playerPrevRegionPosX, this.playerPrevRegionPosZ));
        }
    }

    public static enum RenderMode {
        NONE,
        CORNERS,
        GRID,
        REGIONS;

    }
}

