/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.itemsearch;

import at.ridgo8.moreoverlays.api.itemsearch.SlotHandler;
import at.ridgo8.moreoverlays.api.itemsearch.SlotViewWrapper;
import at.ridgo8.moreoverlays.config.Config;
import at.ridgo8.moreoverlays.itemsearch.GuiUtils;
import at.ridgo8.moreoverlays.itemsearch.ItemUtils;
import at.ridgo8.moreoverlays.itemsearch.JeiModule;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public class GuiRenderer {
    public static final GuiRenderer INSTANCE = new GuiRenderer();
    private static final float FRAME_RADIUS = 1.0f;
    private static boolean enabled = false;
    private static String lastFilterText = "";
    private static boolean emptyFilter = true;
    private static BiMap<Slot, SlotViewWrapper> views = HashBiMap.create();
    private boolean allowRender = false;
    private int guiOffsetX = 0;
    private int guiOffsetY = 0;
    private boolean drewOverlayInTooltipPhase = false;
    private boolean drewFrameInTooltipPhase = false;

    public void guiInit(Screen gui) {
        if (!this.canShowIn(gui)) {
            return;
        }
        this.guiOffsetX = GuiUtils.getGuiLeft((AbstractContainerScreen)gui);
        this.guiOffsetY = GuiUtils.getGuiTop((AbstractContainerScreen)gui);
    }

    public void guiOpen(Screen gui) {
    }

    public void preDraw(GuiGraphics guiGraphics) {
        Screen guiscr = Minecraft.getInstance().screen;
        if (this.canShowIn(guiscr)) {
            this.allowRender = true;
        }
    }

    public void postDraw(GuiGraphics guiGraphics) {
        Screen guiscr = Minecraft.getInstance().screen;
        if (this.allowRender && this.canShowIn(guiscr)) {
            EditBox textField;
            this.allowRender = false;
            if (enabled && (textField = JeiModule.getJEITextField()) != null && !this.drewFrameInTooltipPhase) {
                this.drawSearchFrame(textField, guiGraphics);
            }
            if (!this.drewOverlayInTooltipPhase) {
                this.drawSlotOverlay(guiGraphics, (AbstractContainerScreen)guiscr);
            }
            this.drewOverlayInTooltipPhase = false;
            this.drewFrameInTooltipPhase = false;
        }
    }

    private void drawSearchFrame(EditBox textField, GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 350.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        int x = textField.getX() - 2;
        int y = textField.getY() - 4;
        int width = textField.getWidth() + 8;
        int height = textField.getHeight() - 4;
        int rgb = (Integer)Config.search_searchBoxColor.get() & 0xFFFFFF;
        int color = 0xFF000000 | rgb;
        int left = x - 1;
        int top = y - 1;
        int right = x + width + 1;
        int bottom = y + height + 1;
        guiGraphics.fill(left, top, right, y, color);
        guiGraphics.fill(left, y + height, right, bottom, color);
        guiGraphics.fill(left, y, x, y + height, color);
        guiGraphics.fill(x + width, y, right, y + height, color);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public void renderTooltip(GuiGraphics guiGraphics) {
        Screen guiscr = Minecraft.getInstance().screen;
        if (enabled && this.canShowIn(guiscr)) {
            EditBox textField = JeiModule.getJEITextField();
            if (textField != null) {
                this.drawSearchFrame(textField, guiGraphics);
                this.drewFrameInTooltipPhase = true;
            }
            this.drawSlotOverlay(guiGraphics, (AbstractContainerScreen)guiscr);
            this.drewOverlayInTooltipPhase = true;
        }
    }

    private void drawSlotOverlay(GuiGraphics guiGraphics, AbstractContainerScreen<?> gui) {
        if (!enabled || views == null || views.isEmpty()) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 300.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        float r = (float)((Integer)Config.search_filteredSlotColor.get() >> 16 & 0xFF) / 255.0f;
        float g = (float)((Integer)Config.search_filteredSlotColor.get() >> 8 & 0xFF) / 255.0f;
        float b = (float)((Integer)Config.search_filteredSlotColor.get() & 0xFF) / 255.0f;
        float a = ((Double)Config.search_filteredSlotTransparancy.get()).floatValue();
        for (Map.Entry entry : views.entrySet()) {
            if (!((SlotViewWrapper)entry.getValue()).isEnableOverlay()) continue;
            Vec2 pos = ((SlotViewWrapper)entry.getValue()).getView().getRenderPos(this.guiOffsetX, this.guiOffsetY);
            int left = Math.round(pos.x) + this.guiOffsetX;
            int top = Math.round(pos.y) + this.guiOffsetY;
            int right = left + 16;
            int bottom = top + 16;
            int argb = (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
            guiGraphics.fill(left, top, right, bottom, argb);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public boolean canShowIn(Screen gui) {
        return gui instanceof AbstractContainerScreen && ((AbstractContainerScreen)gui).getMenu() != null && !((AbstractContainerScreen)gui).getMenu().slots.isEmpty();
    }

    private void checkSlots(AbstractContainerScreen<?> container) {
        if (views == null) {
            views = HashBiMap.create();
        } else {
            views.clear();
        }
        List filteredIngredients = JeiModule.filter.getFilteredIngredients((IIngredientType)VanillaTypes.ITEM_STACK);
        if (filteredIngredients.size() > (Integer)Config.search_maxResults.get()) {
            return;
        }
        for (Slot slot : container.getMenu().slots) {
            SlotViewWrapper wrapper;
            if (!views.containsKey((Object)slot)) {
                wrapper = new SlotViewWrapper(SlotHandler.INSTANCE.getViewSlot(container, slot));
                views.put((Object)slot, (Object)wrapper);
            } else {
                wrapper = (SlotViewWrapper)views.get((Object)slot);
            }
            wrapper.setEnableOverlay(wrapper.getView().canSearch() && !this.isSearchedItem(slot.getItem(), filteredIngredients));
        }
    }

    private boolean isSearchedItem(ItemStack stack, List<ItemStack> filteredIngredients) {
        if (emptyFilter) {
            return true;
        }
        if (stack.isEmpty()) {
            return false;
        }
        for (ItemStack ingredient : filteredIngredients) {
            if (!ItemUtils.ingredientMatches(ingredient, stack)) continue;
            return true;
        }
        return this.matchesTooltipAndDisplayName(stack);
    }

    private boolean matchesTooltipAndDisplayName(ItemStack stack) {
        String searchString = JeiModule.getJEITextField().getValue().toLowerCase(Locale.ROOT);
        String[] searchWords = searchString.split(" ");
        return stack.getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), (Player)Minecraft.getInstance().player, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().anyMatch(tip -> {
            String tipLower = tip.getString().toLowerCase(Locale.ROOT);
            String displayNameLower = stack.getDisplayName().getString().toLowerCase(Locale.ROOT);
            if (Arrays.stream(searchWords).allMatch(tipLower::contains)) return true;
            if (!Arrays.stream(searchWords).allMatch(displayNameLower::contains)) return false;
            return true;
        });
    }

    public void tick() {
        Screen screen = Minecraft.getInstance().screen;
        if (!this.canShowIn(screen)) {
            return;
        }
        if (enabled && !JeiModule.filter.getFilterText().equals(lastFilterText)) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        }
        if (enabled && screen instanceof AbstractContainerScreen) {
            this.checkSlots((AbstractContainerScreen)screen);
            this.guiOffsetX = GuiUtils.getGuiLeft((AbstractContainerScreen)screen);
            this.guiOffsetY = GuiUtils.getGuiTop((AbstractContainerScreen)screen);
        } else if (views != null) {
            views.clear();
        }
    }

    public void toggleMode() {
        if (!((Boolean)Config.search_enabled.get()).booleanValue()) {
            enabled = false;
            return;
        }
        boolean bl = enabled = !enabled;
        if (enabled) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        } else {
            lastFilterText = "";
        }
    }

    public boolean isEnabled() {
        return enabled;
    }
}

