/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay;

import at.ridgo8.moreoverlays.MoreOverlays;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.api.lightoverlay.LightOverlayReloadHandlerEvent;
import at.ridgo8.moreoverlays.config.Config;
import at.ridgo8.moreoverlays.lightoverlay.LightScannerVanilla;
import at.ridgo8.moreoverlays.lightoverlay.render.CrossOverlayRenderer;
import at.ridgo8.moreoverlays.lightoverlay.render.NumberOverlayRenderer;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class LightOverlayHandler {
    private static boolean enabled = false;
    public static ILightRenderer renderer = null;
    public static ILightScanner scanner = null;
    private static long clientTickCounter = 0L;
    private static int lastPlayerBlockX = Integer.MIN_VALUE;
    private static int lastPlayerBlockY = Integer.MIN_VALUE;
    private static int lastPlayerBlockZ = Integer.MIN_VALUE;
    private static float lastPlayerYaw = Float.NaN;
    private static boolean lastRenderNumbers = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new LightOverlayHandler());
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        if (LightOverlayHandler.enabled == enabled) {
            return;
        }
        if (enabled) {
            LightOverlayHandler.reloadHandlerInternal();
            Minecraft.getInstance().player.displayClientMessage(Component.nullToEmpty((String)(String.valueOf(ChatFormatting.YELLOW) + "Light Overlay Enabled")), true);
            if (Minecraft.getInstance().player != null) {
                scanner.update((Player)Minecraft.getInstance().player);
                BlockPos bp = Minecraft.getInstance().player.blockPosition();
                lastPlayerBlockX = bp.getX();
                lastPlayerBlockY = bp.getY();
                lastPlayerBlockZ = bp.getZ();
                lastPlayerYaw = Minecraft.getInstance().player.getYRot();
                clientTickCounter = 0L;
                lastRenderNumbers = (Boolean)Config.render_spawnNumbers.get();
            }
        } else {
            scanner.clear();
            Minecraft.getInstance().player.displayClientMessage(Component.nullToEmpty((String)(String.valueOf(ChatFormatting.YELLOW) + "Light Overlay Disabled")), true);
        }
        LightOverlayHandler.enabled = enabled;
    }

    public static void reloadHandler() {
        if (enabled) {
            MoreOverlays.logger.info("Light overlay handlers reloaded");
            LightOverlayHandler.reloadHandlerInternal();
        }
    }

    private static void reloadHandlerInternal() {
        Class rendererCls = (Boolean)Config.render_spawnNumbers.get() != false ? NumberOverlayRenderer.class : CrossOverlayRenderer.class;
        LightOverlayReloadHandlerEvent event = new LightOverlayReloadHandlerEvent((Boolean)Config.light_IgnoreSpawnList.get(), rendererCls, LightScannerVanilla.class);
        NeoForge.EVENT_BUS.post((Event)event);
        if (renderer == null || renderer.getClass() != event.getRenderer()) {
            try {
                renderer = event.getRenderer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                MoreOverlays.logger.warn((Message)new FormattedMessage("Could not create ILightRenderer from type \"%s\"!", (Object)event.getRenderer().getName()), (Throwable)e);
                renderer = new CrossOverlayRenderer();
            }
        }
        if (scanner == null || scanner.getClass() != event.getScanner()) {
            if (scanner != null && enabled) {
                scanner.clear();
            }
            try {
                scanner = event.getScanner().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                MoreOverlays.logger.warn((Message)new FormattedMessage("Could not create ILightScanner from type \"%s\"!", (Object)event.getScanner().getName()), (Throwable)e);
                scanner = new LightScannerVanilla();
            }
        }
        lastRenderNumbers = (Boolean)Config.render_spawnNumbers.get();
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        LightOverlayHandler.setEnabled(false);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderLevelStageEvent event) {
        if (!event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            return;
        }
        if (enabled) {
            renderer.renderOverlays(scanner, event.getPoseStack());
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().player != null && enabled && (Minecraft.getInstance().screen == null || !Minecraft.getInstance().screen.isPauseScreen())) {
            boolean periodicRefresh;
            LocalPlayer player;
            BlockPos bp;
            ++clientTickCounter;
            boolean currentRenderNumbers = (Boolean)Config.render_spawnNumbers.get();
            if (currentRenderNumbers != lastRenderNumbers) {
                LightOverlayHandler.reloadHandlerInternal();
                lastRenderNumbers = currentRenderNumbers;
            }
            boolean movedBlock = (bp = (player = Minecraft.getInstance().player).blockPosition()).getX() != lastPlayerBlockX || bp.getY() != lastPlayerBlockY || bp.getZ() != lastPlayerBlockZ;
            float yaw = player.getYRot();
            boolean rotated = Float.isNaN(lastPlayerYaw) || Math.abs(yaw - lastPlayerYaw) > 15.0f;
            int updateInterval = Math.max(1, (Integer)Config.light_UpdateIntervalFrames.get());
            boolean bl = periodicRefresh = clientTickCounter % (long)updateInterval == 0L;
            if (movedBlock || rotated || periodicRefresh) {
                scanner.update((Player)player);
                lastPlayerBlockX = bp.getX();
                lastPlayerBlockY = bp.getY();
                lastPlayerBlockZ = bp.getZ();
                lastPlayerYaw = yaw;
            }
        }
    }
}

