/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.AbstractConfigTag;
import codechicken.lib.config.ConfigCategoryImpl;
import codechicken.lib.config.ConfigValue;
import codechicken.lib.config.Restriction;
import codechicken.lib.config.ValueType;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigValueImpl
extends AbstractConfigTag<ConfigValue>
implements ConfigValue {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigValueImpl.class);
    @Nullable
    private Object defaultValue = null;
    @Nullable
    private Object value = null;
    @Nullable
    private Object networkValue = null;
    private ValueType type = ValueType.UNKNOWN;
    @Nullable
    private Restriction restriction;

    public ConfigValueImpl(String name, @Nullable ConfigCategoryImpl parent) {
        super(name, parent);
    }

    static ConfigValue proxy(Object value, ValueType type) {
        ConfigValueImpl val = new ConfigValueImpl("proxy", null);
        val.setKnownType(type);
        val.setValue(value);
        return val;
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    @Override
    public boolean getBoolean() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.BOOLEAN;
        }
        if (this.type != ValueType.BOOLEAN) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return (Boolean)this.networkValue;
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultBoolean();
        }
        return (Boolean)this.value;
    }

    @Override
    public String getString() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.STRING;
        }
        if (this.type != ValueType.STRING) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return (String)this.networkValue;
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultString();
        }
        return (String)this.value;
    }

    @Override
    public int getInt() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.INT;
        }
        if (this.type != ValueType.INT) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return (Integer)this.networkValue;
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultInt();
        }
        return (Integer)this.value;
    }

    @Override
    public long getLong() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.LONG;
        }
        if (this.type != ValueType.LONG) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return (Long)this.networkValue;
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultLong();
        }
        return (Long)this.value;
    }

    @Override
    public int getHex() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.HEX;
        }
        if (this.type != ValueType.HEX) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return (Integer)this.networkValue;
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultHex();
        }
        return (Integer)this.value;
    }

    @Override
    public double getDouble() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.DOUBLE;
        }
        if (this.type != ValueType.DOUBLE) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return (Double)this.networkValue;
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultDouble();
        }
        return (Double)this.value;
    }

    @Override
    public ConfigValue setBoolean(boolean value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.BOOLEAN;
        }
        if (this.type != ValueType.BOOLEAN) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(value);
    }

    @Override
    public ConfigValue setString(String value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.STRING;
        }
        if (this.type != ValueType.STRING) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(value);
    }

    @Override
    public ConfigValue setInt(int value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.INT;
        }
        if (this.type != ValueType.INT) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(value);
    }

    @Override
    public ConfigValue setLong(long value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.LONG;
        }
        if (this.type != ValueType.LONG) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(value);
    }

    @Override
    public ConfigValue setHex(int value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.HEX;
        }
        if (this.type != ValueType.HEX) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(value);
    }

    @Override
    public ConfigValue setDouble(double value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.DOUBLE;
        }
        if (this.type != ValueType.DOUBLE) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(value);
    }

    @Override
    public boolean getDefaultBoolean() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.BOOLEAN) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return (Boolean)this.defaultValue;
    }

    @Override
    public String getDefaultString() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.STRING) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return (String)this.defaultValue;
    }

    @Override
    public int getDefaultInt() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.INT) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return (Integer)this.defaultValue;
    }

    @Override
    public long getDefaultLong() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.LONG) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return (Long)this.defaultValue;
    }

    @Override
    public int getDefaultHex() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.HEX) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return (Integer)this.defaultValue;
    }

    @Override
    public double getDefaultDouble() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.DOUBLE) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return (Double)this.defaultValue;
    }

    @Override
    public ConfigValue setDefaultBoolean(boolean value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.BOOLEAN;
        }
        if (this.type != ValueType.BOOLEAN) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue(value);
    }

    @Override
    public ConfigValue setDefaultString(String value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.STRING;
        }
        if (this.type != ValueType.STRING) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue(value);
    }

    @Override
    public ConfigValue setDefaultInt(int value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.INT;
        }
        if (this.type != ValueType.INT) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue(value);
    }

    @Override
    public ConfigValue setDefaultLong(long value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.LONG;
        }
        if (this.type != ValueType.LONG) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue(value);
    }

    @Override
    public ConfigValue setDefaultHex(int value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.HEX;
        }
        if (this.type != ValueType.HEX) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue(value);
    }

    @Override
    public ConfigValue setDefaultDouble(double value) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.DOUBLE;
        }
        if (this.type != ValueType.DOUBLE) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue(value);
    }

    @Override
    public ConfigValue setRestriction(Restriction restriction) {
        this.restriction = restriction;
        if (this.defaultValue != null && !restriction.test(ConfigValueImpl.proxy(this.defaultValue, this.type))) {
            throw new IllegalStateException("Default value is not accepted by Restriction.");
        }
        return this;
    }

    @Override
    @Nullable
    public Restriction getRestriction() {
        return this.restriction;
    }

    @Override
    public void reset() {
        if (this.defaultValue != null) {
            this.value = null;
            this.dirty = true;
        }
    }

    @Override
    public AbstractConfigTag<ConfigValue> copy(@Nullable ConfigCategoryImpl parent) {
        ConfigValueImpl clone = new ConfigValueImpl(this.getName(), parent);
        clone.comment = List.copyOf(this.comment);
        clone.defaultValue = this.defaultValue;
        clone.value = this.value;
        clone.type = this.type;
        clone.restriction = this.restriction;
        return clone;
    }

    @Override
    public void write(MCDataOutput out) {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tried to write UNKNOWN tag to network");
        }
        out.writeEnum(this.type);
        switch (this.type) {
            case BOOLEAN: {
                out.writeBoolean(this.getBoolean());
                break;
            }
            case STRING: {
                out.writeString(this.getString());
                break;
            }
            case INT: {
                out.writeInt(this.getInt());
                break;
            }
            case LONG: {
                out.writeLong(this.getLong());
                break;
            }
            case HEX: {
                out.writeInt(this.getHex());
                break;
            }
            case DOUBLE: {
                out.writeDouble(this.getDouble());
            }
        }
    }

    @Override
    public void read(MCDataInput in) {
        ValueType netType = in.readEnum(ValueType.class);
        if (this.networkSynthetic) {
            this.type = netType;
        }
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tried to read into an UNKNOWN tag from the network");
        }
        if (netType != this.type) {
            throw new IllegalStateException("Tried to read a " + String.valueOf((Object)netType) + " tag from the network into a " + String.valueOf((Object)this.type) + " tag");
        }
        switch (this.type) {
            case BOOLEAN: {
                this.networkValue = in.readBoolean();
                break;
            }
            case STRING: {
                this.networkValue = in.readString();
                break;
            }
            case INT: 
            case HEX: {
                this.networkValue = in.readInt();
                break;
            }
            case LONG: {
                this.networkValue = in.readLong();
                break;
            }
            case DOUBLE: {
                this.networkValue = in.readDouble();
            }
        }
    }

    @Override
    public void resetFromNetwork() {
        this.networkValue = null;
    }

    public ConfigValue setValue(Object value) {
        this.value = value;
        if (this.type != ValueType.UNKNOWN) {
            this.value = this.tryConvert(this.value, this.type);
        }
        this.dirty = true;
        return this;
    }

    public ConfigValue setDefaultValue(Object value) {
        if (this.restriction != null && !this.restriction.test(ConfigValueImpl.proxy(value, this.type))) {
            throw new IllegalStateException("Default value is not accepted by Restriction.");
        }
        this.defaultValue = value;
        this.dirty = true;
        return this;
    }

    public Object getRawValue() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        this.value = this.tryConvert(this.value, this.type);
        return this.getRealRawValue();
    }

    @VisibleForTesting
    Object getRealRawValue() {
        if (this.value == null) {
            if (this.defaultValue == null) {
                throw new IllegalStateException("Default value not set.");
            }
            return this.defaultValue;
        }
        return this.value;
    }

    public void setKnownType(ValueType type) {
        this.type = type;
    }

    @Nullable
    Object tryConvert(@Nullable Object object, ValueType type) {
        if (object == null) {
            return null;
        }
        try {
            object = ConfigValueImpl.convert(object, type);
        }
        catch (IllegalStateException ex) {
            LOGGER.error("Failed to convert config tag {} to {}. Resetting to default.", new Object[]{this.getDesc(), type, ex});
            this.dirty = true;
            return null;
        }
        if (this.restriction != null && !this.restriction.test(ConfigValueImpl.proxy(object, type))) {
            LOGGER.error("Value violates restriction, Resetting to default. Tag {}, Value {}, Restriction {}", new Object[]{this.getDesc(), object, this.restriction.describe()});
            this.dirty = true;
            return null;
        }
        return object;
    }

    static Object convert(Object object, ValueType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ValueType.UNKNOWN -> throw new AssertionError((Object)"Impossible to reach this branch.");
            case ValueType.BOOLEAN -> ConfigValueImpl.convertToBoolean(object);
            case ValueType.STRING -> object.toString();
            case ValueType.INT -> ConfigValueImpl.convertToInteger(object);
            case ValueType.LONG -> ConfigValueImpl.convertToLong(object);
            case ValueType.HEX -> ConfigValueImpl.convertToHex(object);
            case ValueType.DOUBLE -> ConfigValueImpl.convertToDouble(object);
        };
    }

    static Boolean convertToBoolean(Object object) {
        String str;
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool;
        }
        return switch (str = object.toString().toLowerCase(Locale.ROOT)) {
            case "true" -> Boolean.TRUE;
            case "false" -> Boolean.FALSE;
            default -> throw new IllegalStateException("Unable to convert value '" + str + "' to a Boolean.");
        };
    }

    static Integer convertToInteger(Object object) {
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("Unable to convert value '" + String.valueOf(object) + "' to a Integer.", ex);
        }
    }

    static Long convertToLong(Object object) {
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("Unable to convert value '" + String.valueOf(object) + "' to a Long.", ex);
        }
    }

    static Integer convertToHex(Object object) {
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.intValue();
        }
        try {
            return (int)Long.parseLong(object.toString().replace("0x", ""), 16);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("Unable to convert value '" + String.valueOf(object) + "' to Hex.", ex);
        }
    }

    static Double convertToDouble(Object object) {
        if (object instanceof Double) {
            Double d = (Double)object;
            return d;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("Unable to convert value '" + String.valueOf(object) + "' to a Double.", ex);
        }
    }
}

