/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config.parser;

import codechicken.lib.config.AbstractConfigTag;
import codechicken.lib.config.ConfigCategoryImpl;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigValueImpl;
import codechicken.lib.config.ConfigValueListImpl;
import codechicken.lib.config.ValueType;
import codechicken.lib.config.parser.ConfigParseException;
import codechicken.lib.config.parser.ConfigSerializer;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2CharArrayMap;
import it.unimi.dsi.fastutil.objects.Object2CharMap;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.covers1624.quack.io.IOUtils;
import net.minecraft.Util;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyConfigSerializer
implements ConfigSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyConfigSerializer.class);
    private static final Pattern QUOTE_PATTERN = Pattern.compile("(?<=\")(.*)(?=\")");
    private static final Pattern STRING_MATCHER = Pattern.compile("(?<=.:\")(.*)(\"=\")(.*)(?=\")");
    private static final Char2ObjectMap<ValueType> valueTypeLookup = (Char2ObjectMap)Util.make((Object)new Char2ObjectArrayMap(), e -> {
        e.put('B', (Object)ValueType.BOOLEAN);
        e.put('S', (Object)ValueType.STRING);
        e.put('I', (Object)ValueType.INT);
        e.put('L', (Object)ValueType.LONG);
        e.put('H', (Object)ValueType.HEX);
        e.put('D', (Object)ValueType.DOUBLE);
    });
    private static final Object2CharMap<ValueType> charLookup = (Object2CharMap)Util.make((Object)new Object2CharArrayMap(), e -> {
        for (Char2ObjectMap.Entry entry : valueTypeLookup.char2ObjectEntrySet()) {
            e.put((Object)((ValueType)((Object)((Object)entry.getValue()))), entry.getCharKey());
        }
    });

    @Override
    public void parse(Path file, ConfigCategoryImpl rootTag) throws IOException {
        try (ConfigReader reader = new ConfigReader(Files.newBufferedReader(file));){
            this.parse(rootTag, reader);
        }
    }

    private void parse(ConfigCategoryImpl category, ConfigReader reader) throws IOException {
        String line;
        while ((line = LegacyConfigSerializer.readLine(reader)) != null) {
            AbstractConfigTag tag;
            if (line.isEmpty() || line.startsWith("//") || line.startsWith("#")) continue;
            if (line.startsWith("}")) break;
            if (line.startsWith("~")) {
                category.getValue("~version").setString(line.substring(1));
                continue;
            }
            if (line.startsWith("\"") && line.endsWith("{")) {
                Matcher matcher = QUOTE_PATTERN.matcher(line);
                if (!matcher.find()) {
                    throw new ConfigParseException("Malformed line! @%s, %s", reader.line, line);
                }
                String name = matcher.group();
                this.parse(category.getCategory(name), reader);
                continue;
            }
            boolean isList = line.endsWith("<");
            char first = line.charAt(0);
            ValueType type = (ValueType)((Object)valueTypeLookup.get(first));
            if (type == null) {
                throw new ConfigParseException("Invalid value type %s, @Line:%s, '%s'", Character.valueOf(first), reader.line, line);
            }
            Matcher matcher = (type != ValueType.STRING || isList ? QUOTE_PATTERN : STRING_MATCHER).matcher(line);
            if (!matcher.find()) {
                throw new ConfigParseException("Malformed line! @%s, '%s'", reader.line, line);
            }
            String name = matcher.group(1);
            if (!isList) {
                String value;
                tag = category.getValue(name);
                ((ConfigValueImpl)tag).setKnownType(type);
                if (type == ValueType.STRING) {
                    value = matcher.group(3);
                } else {
                    int equals = line.indexOf(61);
                    if (equals == -1) {
                        throw new ConfigParseException("Malformed line! @%s, '%s', Expected equals sign.", reader.line, line);
                    }
                    value = line.substring(equals + 1);
                }
                ((ConfigValueImpl)tag).setValue(value);
                continue;
            }
            tag = category.getValueList(name);
            ((ConfigValueListImpl)tag).setKnownType(type);
            LinkedList<String> list = new LinkedList<String>();
            while (true) {
                String listLine;
                if ((listLine = LegacyConfigSerializer.readLine(reader)) == null) {
                    throw new EOFException("End of line reached whilst parsing list?");
                }
                if (listLine.startsWith(">")) break;
                list.add(listLine);
            }
            ((ConfigValueListImpl)tag).setValue(list);
        }
    }

    @Nullable
    protected static String readLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        return line == null ? null : line.trim();
    }

    @Override
    public void save(Path file, ConfigCategoryImpl rootTag) throws IOException {
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(IOUtils.makeParents((Path)file), new OpenOption[0]));){
            this.writeTag(rootTag, writer, -1);
        }
    }

    private void writeTag(ConfigTag tag, PrintWriter writer, int depth) {
        if (tag instanceof ConfigCategoryImpl) {
            boolean isRootTag;
            ConfigCategoryImpl cat = (ConfigCategoryImpl)tag;
            boolean bl = isRootTag = depth == -1;
            if (!isRootTag) {
                LegacyConfigSerializer.writeLine(writer, depth, "\"%s\" {", tag.getName());
            }
            ++depth;
            boolean first = true;
            for (ConfigTag child : cat.getChildren()) {
                List<String> comment;
                if (child.isNetworkTag()) continue;
                if (!first) {
                    writer.println();
                }
                if (!(comment = child.getComment()).isEmpty()) {
                    for (String line : comment) {
                        LegacyConfigSerializer.writeLine(writer, depth, "# " + line, new Object[0]);
                    }
                }
                first = false;
                this.writeTag(child, writer, depth);
            }
            if (!isRootTag) {
                LegacyConfigSerializer.writeLine(writer, depth - 1, "}", new Object[0]);
            }
        } else if (tag instanceof ConfigValueImpl) {
            ConfigValueImpl val = (ConfigValueImpl)tag;
            Object value = val.getRawValue();
            if (val.getType() == ValueType.STRING) {
                value = "\"" + String.valueOf(value) + "\"";
            }
            LegacyConfigSerializer.writeLine(writer, depth, "%s:\"%s\"=%s", Character.valueOf(charLookup.getChar((Object)val.getType())), val.getName(), LegacyConfigSerializer.toString(value, val.getType()));
        } else if (tag instanceof ConfigValueListImpl) {
            ConfigValueListImpl list = (ConfigValueListImpl)tag;
            List<?> lst = list.getRawValue();
            LegacyConfigSerializer.writeLine(writer, depth, "%s:\"%s\" <", Character.valueOf(charLookup.getChar((Object)list.getType())), list.getName());
            for (Object e : lst) {
                LegacyConfigSerializer.writeLine(writer, depth + 1, "%s", LegacyConfigSerializer.toString(e, list.getType()));
            }
            LegacyConfigSerializer.writeLine(writer, depth, ">", new Object[0]);
        } else {
            throw new IllegalStateException("Unknown tag type: " + tag.getClass().getName());
        }
    }

    private static String toString(Object val, ValueType type) {
        if (type == ValueType.HEX) {
            return "0x" + Long.toString((long)((Integer)val).intValue() << 32 >>> 32, 16).toUpperCase();
        }
        return val.toString();
    }

    private static void writeLine(PrintWriter writer, int tabs, String line, Object ... data) {
        for (int i = 0; i < tabs; ++i) {
            writer.print('\t');
        }
        writer.println(String.format(line, data));
    }

    private static class ConfigReader
    extends BufferedReader {
        public int line;

        public ConfigReader(Reader in) {
            super(in);
        }

        @Override
        public String readLine() throws IOException {
            ++this.line;
            return super.readLine();
        }
    }
}

