/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public abstract class LanguageProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> client = new TreeMap<String, String>();
    private final Map<String, String> server = new TreeMap<String, String>();
    private final PackOutput output;
    private final String modid;
    private final String locale;
    private final Side distFilter;

    protected LanguageProvider(PackOutput output, String modid, String locale, Side distFilter) {
        this.output = output;
        this.modid = modid;
        this.locale = locale;
        this.distFilter = distFilter;
    }

    protected abstract void addTranslations();

    public CompletableFuture<?> run(CachedOutput p_200398_1_) {
        this.addTranslations();
        LinkedList<CompletableFuture> futures = new LinkedList<CompletableFuture>();
        if (this.distFilter.includeClient() && !this.client.isEmpty()) {
            futures.add(DataProvider.saveStable((CachedOutput)p_200398_1_, (JsonElement)GSON.toJsonTree(this.client), (Path)this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.modid + "/lang/" + this.locale + ".json")));
        }
        if (this.distFilter.includeServer() && !this.server.isEmpty()) {
            futures.add(DataProvider.saveStable((CachedOutput)p_200398_1_, (JsonElement)GSON.toJsonTree(this.server), (Path)this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid + "/lang/" + this.locale + ".json")));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return this.modid + " Languages: " + this.locale;
    }

    public String getLocale() {
        return this.locale;
    }

    private void save(CachedOutput cache, Object object, Path target) {
        DataProvider.saveStable((CachedOutput)cache, (JsonElement)GSON.toJsonTree(object), (Path)target);
    }

    public void add(Block key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void add(Item key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void add(Supplier<? extends ItemLike> key, String name) {
        this.add(key.get().asItem(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void add(MobEffect key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get().getDescriptionId(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get().getDescriptionId(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get().getDescriptionId(), name);
    }

    public void addEffect(Supplier<MobEffect> key, String name) {
        this.add(key.get().getDescriptionId(), name);
    }

    public void addEntityType(Supplier<EntityType<?>> key, String name) {
        this.add(key.get().getDescriptionId(), name);
    }

    public void add(String key, String name) {
        if (this.client.put(key, name) != null) {
            throw new IllegalArgumentException("Duplicate translation key :" + key);
        }
    }

    public void addServer(String key, String name) {
        this.add(key, name);
        if (this.server.put(key, name) != null) {
            throw new IllegalArgumentException("Duplicate translation key :" + key);
        }
    }

    public static Side getDist(GatherDataEvent event) {
        if (event.includeServer() && event.includeClient()) {
            return Side.BOTH;
        }
        if (event.includeServer()) {
            return Side.SERVER;
        }
        if (event.includeClient()) {
            return Side.CLIENT;
        }
        return Side.NONE;
    }

    public static enum Side {
        CLIENT,
        SERVER,
        BOTH,
        NONE;


        public boolean includeClient() {
            return this == CLIENT || this == BOTH;
        }

        public boolean includeServer() {
            return this == SERVER || this == BOTH;
        }
    }
}

