/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.dev;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;

public class DevCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ccl").then(((LiteralArgumentBuilder)Commands.literal((String)"setup_dev_world").requires(e -> e.hasPermission(4))).executes(DevCommands::setupWorld)));
    }

    private static int setupWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        MinecraftServer server = source.getServer();
        GameRules gameRules = server.getGameRules();
        for (ServerLevel level : server.getAllLevels()) {
            level.setWeatherParameters(6000, 0, false, false);
        }
        ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_DAYLIGHT)).set(false, server);
        ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_WEATHER_CYCLE)).set(false, server);
        ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_DO_TRADER_SPAWNING)).set(false, server);
        return 0;
    }
}

