/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.mixin;

import codechicken.lib.render.item.IItemRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ClientHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
abstract class ItemRendererMixin {
    ItemRendererMixin() {
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void onRenderItem(ItemStack stack, ItemDisplayContext context, boolean leftHand, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay, BakedModel modelIn, CallbackInfo ci) {
        if (modelIn instanceof IItemRenderer) {
            ci.cancel();
            mStack.pushPose();
            IItemRenderer renderer = (IItemRenderer)ClientHooks.handleCameraTransforms((PoseStack)mStack, (BakedModel)modelIn, (ItemDisplayContext)context, (boolean)leftHand);
            mStack.translate(-0.5, -0.5, -0.5);
            renderer.renderItem(stack, context, mStack, buffers, packedLight, packedOverlay);
            mStack.popPose();
        }
    }
}

