/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.vec.Cuboid6;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeCache {
    private static final Cache<AABB, VoxelShape> bbToShapeCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();
    private static final Cache<Cuboid6, VoxelShape> cuboidToShapeCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();
    private static final Cache<ImmutableSet<VoxelShape>, VoxelShape> mergeShapeCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();

    public static VoxelShape getShape(AABB aabb) {
        VoxelShape shape = (VoxelShape)bbToShapeCache.getIfPresent((Object)aabb);
        if (shape == null) {
            shape = Shapes.create((AABB)aabb);
            bbToShapeCache.put((Object)aabb, (Object)shape);
        }
        return shape;
    }

    public static VoxelShape getShape(Cuboid6 cuboid) {
        VoxelShape shape = (VoxelShape)cuboidToShapeCache.getIfPresent((Object)cuboid);
        if (shape == null) {
            shape = Shapes.box((double)cuboid.min.x, (double)cuboid.min.y, (double)cuboid.min.z, (double)cuboid.max.x, (double)cuboid.max.y, (double)cuboid.max.z);
            cuboidToShapeCache.put((Object)cuboid, (Object)shape);
        }
        return shape;
    }

    public static VoxelShape merge(ImmutableSet<VoxelShape> shapes) {
        VoxelShape shape = (VoxelShape)mergeShapeCache.getIfPresent(shapes);
        if (shape == null) {
            shape = shapes.stream().reduce(Shapes.empty(), Shapes::or);
            mergeShapeCache.put(shapes, (Object)shape);
        }
        return shape;
    }
}

