/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class CCModelLibrary {
    public static final CCModel icosahedron4;
    public static final CCModel icosahedron7;
    private static int i;

    private static void addIcosahedronTriangle(Vector3 vec1, double u1, double v1, Vector3 vec2, double u2, double v2, Vector3 vec3, double u3, double v3) {
        Vertex5 vertex5 = new Vertex5(vec1, u1, v1);
        CCModelLibrary.icosahedron7.verts[CCModelLibrary.i * 4] = vertex5;
        CCModelLibrary.icosahedron4.verts[CCModelLibrary.i * 3] = vertex5;
        Vertex5 vertex52 = new Vertex5(vec2, u2, v2);
        CCModelLibrary.icosahedron7.verts[CCModelLibrary.i * 4 + 1] = vertex52;
        CCModelLibrary.icosahedron4.verts[CCModelLibrary.i * 3 + 1] = vertex52;
        Vertex5 vertex53 = new Vertex5(vec3, u3, v3);
        CCModelLibrary.icosahedron7.verts[CCModelLibrary.i * 4 + 3] = vertex53;
        CCModelLibrary.icosahedron7.verts[CCModelLibrary.i * 4 + 2] = vertex53;
        CCModelLibrary.icosahedron4.verts[CCModelLibrary.i * 3 + 2] = vertex53;
        ++i;
    }

    public static RenderType getIcos4RenderType(ResourceLocation texture) {
        return RenderType.create((String)"icosahedron4", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)CCModelLibrary.makeIcosState(texture));
    }

    public static RenderType getIcos7RenderType(ResourceLocation texture) {
        return RenderType.create((String)"icosahedron7", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)CCModelLibrary.makeIcosState(texture));
    }

    public static RenderType.CompositeState makeIcosState(ResourceLocation texture) {
        return RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_SOLID_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(RenderStateShard.NO_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false);
    }

    static {
        Vector3[] verts = new Vector3[]{new Vector3(-1.0, 1.618033988749894, 0.0), new Vector3(1.0, 1.618033988749894, 0.0), new Vector3(1.0, -1.618033988749894, 0.0), new Vector3(-1.0, -1.618033988749894, 0.0), new Vector3(0.0, -1.0, 1.618033988749894), new Vector3(0.0, 1.0, 1.618033988749894), new Vector3(0.0, 1.0, -1.618033988749894), new Vector3(0.0, -1.0, -1.618033988749894), new Vector3(1.618033988749894, 0.0, -1.0), new Vector3(1.618033988749894, 0.0, 1.0), new Vector3(-1.618033988749894, 0.0, 1.0), new Vector3(-1.618033988749894, 0.0, -1.0)};
        Quat quat = Quat.aroundAxis(0.0, 0.0, 1.0, Math.atan(0.6180339887498951));
        for (Vector3 vec : verts) {
            quat.rotate(vec);
        }
        icosahedron4 = CCModel.newModel(VertexFormat.Mode.TRIANGLES, 60);
        icosahedron7 = CCModel.newModel(VertexFormat.Mode.QUADS, 80);
        i = 0;
        CCModelLibrary.addIcosahedronTriangle(verts[1], 0.5, 0.0, verts[0], 0.0, 0.25, verts[5], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[1], 0.5, 0.0, verts[5], 0.0, 0.25, verts[9], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[1], 0.5, 0.0, verts[9], 0.0, 0.25, verts[8], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[1], 0.5, 0.0, verts[8], 0.0, 0.25, verts[6], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[1], 0.5, 0.0, verts[6], 0.0, 0.25, verts[0], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[0], 0.5, 0.25, verts[11], 0.0, 0.75, verts[10], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(verts[5], 0.5, 0.25, verts[10], 0.0, 0.75, verts[4], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(verts[9], 0.5, 0.25, verts[4], 0.0, 0.75, verts[2], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(verts[8], 0.5, 0.25, verts[2], 0.0, 0.75, verts[7], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(verts[6], 0.5, 0.25, verts[7], 0.0, 0.75, verts[11], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(verts[2], 0.5, 0.75, verts[8], 0.0, 0.25, verts[9], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[7], 0.5, 0.75, verts[6], 0.0, 0.25, verts[8], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[11], 0.5, 0.75, verts[0], 0.0, 0.25, verts[6], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[10], 0.5, 0.75, verts[5], 0.0, 0.25, verts[0], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[4], 0.5, 0.75, verts[9], 0.0, 0.25, verts[5], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(verts[3], 0.5, 1.0, verts[2], 0.0, 0.75, verts[4], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(verts[3], 0.5, 1.0, verts[7], 0.0, 0.75, verts[2], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(verts[3], 0.5, 1.0, verts[11], 0.0, 0.75, verts[7], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(verts[3], 0.5, 1.0, verts[10], 0.0, 0.75, verts[11], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(verts[3], 0.5, 1.0, verts[4], 0.0, 0.75, verts[10], 1.0, 0.75);
        icosahedron4.computeNormals().smoothNormals();
        icosahedron7.computeNormals().smoothNormals();
    }
}

