/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.lighting;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.LC;
import codechicken.lib.render.pipeline.IVertexOperation;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class LightMatrix
implements IVertexOperation {
    public static final int operationIndex = IVertexOperation.registerOperation();
    public int computed = 0;
    public float[][] ao = new float[13][4];
    public int[][] brightness = new int[13][4];
    @Nullable
    public BlockAndTintGetter access;
    public BlockPos pos = BlockPos.ZERO;
    private int sampled = 0;
    private final float[] aSamples = new float[27];
    private final int[] bSamples = new int[27];
    public static final int[][] ssamplem = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8}, {18, 19, 20, 21, 22, 23, 24, 25, 26}, {0, 9, 18, 1, 10, 19, 2, 11, 20}, {6, 15, 24, 7, 16, 25, 8, 17, 26}, {0, 3, 6, 9, 12, 15, 18, 21, 24}, {2, 5, 8, 11, 14, 17, 20, 23, 26}, {9, 10, 11, 12, 13, 14, 15, 16, 17}, {9, 10, 11, 12, 13, 14, 15, 16, 17}, {3, 12, 21, 4, 13, 22, 5, 14, 23}, {3, 12, 21, 4, 13, 22, 5, 14, 23}, {1, 4, 7, 10, 13, 16, 19, 22, 25}, {1, 4, 7, 10, 13, 16, 19, 22, 25}, {13, 13, 13, 13, 13, 13, 13, 13, 13}};
    public static final int[][] qsamplem = new int[][]{{0, 1, 3, 4}, {5, 1, 2, 4}, {6, 7, 3, 4}, {5, 7, 8, 4}};
    public static final float[] sideao = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f, 0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f, 1.0f};

    public void locate(BlockAndTintGetter a, BlockPos bPos) {
        this.access = a;
        this.pos = bPos;
        this.computed = 0;
        this.sampled = 0;
    }

    public void sample(int i) {
        Objects.requireNonNull(this.access, "LightMatrix must be located first.");
        if ((this.sampled & 1 << i) == 0) {
            BlockPos bp = new BlockPos(this.pos.getX() + i % 3 - 1, this.pos.getY() + i / 9 - 1, this.pos.getZ() + i / 3 % 3 - 1);
            BlockState b = this.access.getBlockState(bp);
            this.bSamples[i] = LevelRenderer.getLightColor((BlockAndTintGetter)this.access, (BlockPos)bp);
            this.aSamples[i] = b.getShadeBrightness((BlockGetter)this.access, bp);
            this.sampled |= 1 << i;
        }
    }

    public int[] brightness(int side) {
        this.sideSample(side);
        return this.brightness[side];
    }

    public float[] ao(int side) {
        this.sideSample(side);
        return this.ao[side];
    }

    public void sideSample(int side) {
        if ((this.computed & 1 << side) == 0) {
            int[] ssample = ssamplem[side];
            for (int q = 0; q < 4; ++q) {
                int[] qsample = qsamplem[q];
                if (Minecraft.useAmbientOcclusion()) {
                    this.interp(side, q, ssample[qsample[0]], ssample[qsample[1]], ssample[qsample[2]], ssample[qsample[3]]);
                    continue;
                }
                this.interp(side, q, ssample[4], ssample[4], ssample[4], ssample[4]);
            }
            this.computed |= 1 << side;
        }
    }

    protected void interp(int s, int q, int a, int b, int c, int d) {
        this.sample(a);
        this.sample(b);
        this.sample(c);
        this.sample(d);
        this.ao[s][q] = LightMatrix.interpAO(this.aSamples[a], this.aSamples[b], this.aSamples[c], this.aSamples[d]) * sideao[s];
        this.brightness[s][q] = LightMatrix.interpBrightness(this.bSamples[a], this.bSamples[b], this.bSamples[c], this.bSamples[d]);
    }

    public static float interpAO(float a, float b, float c, float d) {
        return (a + b + c + d) / 4.0f;
    }

    public static int interpBrightness(int a, int b, int c, int d) {
        if (a == 0) {
            a = d;
        }
        if (b == 0) {
            b = d;
        }
        if (c == 0) {
            c = d;
        }
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        if (!ccrs.computeLighting) {
            return false;
        }
        ccrs.pipeline.addDependency(ccrs.colourAttrib);
        ccrs.pipeline.addDependency(ccrs.lightCoordAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        LC lc = ccrs.lc;
        float[] a = this.ao(lc.side);
        float f = a[0] * lc.fa + a[1] * lc.fb + a[2] * lc.fc + a[3] * lc.fd;
        int[] b = this.brightness(lc.side);
        ccrs.colour = ColourRGBA.multiplyC(ccrs.colour, f);
        ccrs.brightness = (int)((float)b[0] * lc.fa + (float)b[1] * lc.fb + (float)b[2] * lc.fc + (float)b[3] * lc.fd) & 0xFF00FF;
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

