/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.util.Copyable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ArrayUtils {
    public static String[] arrayToLowercase(String[] array) {
        String[] copy = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = array[i].toLowerCase();
        }
        return copy;
    }

    public static Map<String, String> convertKeyValueArrayToMap(String[] array) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : array) {
            String[] split = entry.split("=");
            map.put(split[0], split[1]);
        }
        return map;
    }

    public static List<String> prefixStringList(String prefix, List<String> list) {
        ArrayList<String> finalList = new ArrayList<String>();
        for (String string : list) {
            finalList.add(prefix + string);
        }
        return finalList;
    }

    @SafeVarargs
    public static <T> boolean containsKeys(Map<T, ?> map, T ... keys) {
        for (T object : keys) {
            if (map.containsKey(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] addToArrayFirstNull(T[] array, T value) {
        int nullIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            T v = array[i];
            if (v != null) continue;
            nullIndex = i;
            break;
        }
        if (nullIndex == -1) {
            T[] copy = ArrayUtils.createNewArray(array, array.length + 1);
            System.arraycopy(array, 0, copy, 0, array.length);
            nullIndex = array.length;
            array = copy;
        }
        array[nullIndex] = value;
        return array;
    }

    public static <T> List<T> addAllNoNull(T[] array, List<T> list) {
        for (T value : array) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public static <T> boolean isEmpty(T[] array) {
        for (T value : array) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public static <T> int countNoNull(T[] array) {
        return ArrayUtils.count(array, Objects::nonNull);
    }

    public static <T> int count(T[] array, Function<T, Boolean> check) {
        int counter = 0;
        for (T value : array) {
            if (!check.apply(value).booleanValue()) continue;
            ++counter;
        }
        return counter;
    }

    public static <T> T[] fill(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            T newValue = value;
            if (value instanceof Copyable) {
                newValue = ((Copyable)value).copy();
            }
            array[i] = newValue;
        }
        return array;
    }

    public static <T> void fillArray(T[] array, T value, Function<T, Boolean> check) {
        for (int i = 0; i < array.length; ++i) {
            if (!check.apply(array[i]).booleanValue()) continue;
            T newValue = value;
            if (value instanceof Copyable) {
                newValue = ((Copyable)value).copy();
            }
            array[i] = newValue;
        }
    }

    public static <I, O> List<O> applyArray(Function<I, O> function, I ... array) {
        ArrayList<O> finalList = new ArrayList<O>();
        for (I i : array) {
            finalList.add(function.apply(i));
        }
        return finalList;
    }

    public static void arrayCopy(Object src, int srcPos, Object dst, int destPos, int length) {
        System.arraycopy(src, srcPos, dst, destPos, length);
        if (dst instanceof Copyable[]) {
            Object[] oa = (Object[])dst;
            Copyable[] c = (Copyable[])dst;
            for (int i = destPos; i < destPos + length; ++i) {
                if (c[i] == null) continue;
                oa[i] = c[i].copy();
            }
        }
    }

    public static <T> int indexOf(T[] array, @Nullable T object) {
        if (object == null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (!object.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int indexOfRef(T[] array, T object) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] createNewArray(T[] array) {
        return ArrayUtils.createNewArray(array, array.length);
    }

    public static <T> T[] createNewArray(T[] array, int length) {
        Class<?> newType = array.getClass();
        Object[] copy = newType.equals(Object[].class) ? new Object[length] : ArrayUtils.newArray(newType.getComponentType(), length);
        return copy;
    }

    public static <T> T[] newArray(Class<T> arrayClass, int length) {
        return (Object[])Array.newInstance(arrayClass, length);
    }

    public static <T> T[] rollArray(T[] input, int shift) {
        T[] newArray = ArrayUtils.createNewArray(input);
        for (int i = 0; i < input.length; ++i) {
            int newPos = (i + shift) % input.length;
            if (newPos < 0) {
                newPos += input.length;
            }
            newArray[newPos] = input[i];
        }
        return newArray;
    }

    public static <T> boolean contains(T[] input, @Nullable T element) {
        for (T test : input) {
            if (!Objects.equals(test, element)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] inverse(T[] input, T[] allElements) {
        LinkedList<T> list = new LinkedList<T>();
        for (T e : allElements) {
            if (ArrayUtils.contains(input, e)) continue;
            list.add(e);
        }
        return list.toArray(ArrayUtils.createNewArray(input, list.size()));
    }

    public static <T> boolean isNullOrContainsNull(T @Nullable [] input) {
        if (input != null) {
            for (T t : input) {
                if (t != null) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static List<Integer> toList(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : arr) {
            list.add(i);
        }
        return list;
    }
}

