/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.multipiston;

import com.google.common.primitives.Ints;
import com.ldtteam.multipiston.ModBlocks;
import com.ldtteam.multipiston.ModTileEntities;
import com.ldtteam.structurize.api.IRotatableBlockEntity;
import com.ldtteam.structurize.api.RotationMirror;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityMultiPiston
extends BlockEntity
implements IRotatableBlockEntity {
    public static final String TAG_INPUT = "input";
    public static final String TAG_RANGE = "range";
    public static final String TAG_DIRECTION = "direction";
    public static final String TAG_LENGTH = "length";
    public static final String TAG_PROGRESS = "progress";
    public static final String TAG_OUTPUT_DIRECTION = "outputDirection";
    public static final String TAG_SPEED = "speed";
    public static final double VOLUME = 0.5;
    public static final double PITCH = 0.8;
    private static final int MAX_RANGE = 10;
    private static final int MAX_SPEED = 3;
    private static final int MIN_SPEED = 1;
    public static final int DEFAULT_RANGE = 3;
    public static final int DEFAULT_SPEED = 2;
    private boolean on = false;
    private Direction input = Direction.UP;
    private Direction output = Direction.DOWN;
    private int range = 3;
    private Direction currentDirection;
    private int progress = 0;
    private int ticksPassed = 0;
    private int speed = 2;

    public TileEntityMultiPiston(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.multipiston.get(), pos, state);
    }

    public void handleRedstone(boolean signal) {
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (signal != this.on && this.progress == this.range) {
            this.on = signal;
            this.currentDirection = signal ? this.output : this.input;
            this.progress = 0;
        }
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.currentDirection == null && this.progress < this.range) {
            this.progress = this.range;
        }
        if (this.progress < this.range) {
            if (this.ticksPassed % (20 / this.speed) == 0) {
                this.handleTick();
                this.ticksPassed = 1;
            }
            ++this.ticksPassed;
        }
    }

    public void handleTick() {
        Direction currentOutPutDirection;
        Direction direction = currentOutPutDirection = this.currentDirection == this.input ? this.output : this.input;
        if (this.progress < this.range) {
            BlockState blockToMove = this.level.getBlockState(this.worldPosition.relative(this.currentDirection, 1));
            if (blockToMove.getBlock() == Blocks.AIR || blockToMove.getPistonPushReaction() == PushReaction.IGNORE || blockToMove.getPistonPushReaction() == PushReaction.DESTROY || blockToMove.getPistonPushReaction() == PushReaction.BLOCK || blockToMove.getBlock() instanceof EntityBlock && !BuiltInRegistries.BLOCK.getKey((Object)blockToMove.getBlock()).getNamespace().equals("domum_ornamentum") && !blockToMove.is(ModBlocks.MOVEABLE_ENTITY_BLOCKS) || blockToMove.getBlock() == Blocks.BEDROCK) {
                ++this.progress;
                return;
            }
            for (int i = 0; i < Math.min(this.range, 10); ++i) {
                BlockEntity blockEntity;
                BlockPos posToGoFrom;
                int blockToGoTo = i - 1 - this.progress + (i - 1 - this.progress >= 0 ? 1 : 0);
                int blockToGoFrom = i + 1 - this.progress - (i + 1 - this.progress <= 0 ? 1 : 0);
                BlockPos posToGo = blockToGoTo > 0 ? this.worldPosition.relative(this.currentDirection, blockToGoTo) : this.worldPosition.relative(currentOutPutDirection, Math.abs(blockToGoTo));
                BlockPos blockPos = posToGoFrom = blockToGoFrom > 0 ? this.worldPosition.relative(this.currentDirection, blockToGoFrom) : this.worldPosition.relative(currentOutPutDirection, Math.abs(blockToGoFrom));
                if (!this.level.isEmptyBlock(posToGo) && !this.level.getBlockState(posToGo).liquid()) continue;
                BlockState tempState = this.level.getBlockState(posToGoFrom);
                if (blockToMove.getBlock() != tempState.getBlock() || !this.level.hasChunkAt(posToGoFrom) || !this.level.hasChunkAt(posToGo)) continue;
                this.pushEntitiesIfNecessary(posToGo, this.worldPosition);
                tempState = Block.updateFromNeighbourShapes((BlockState)tempState, (LevelAccessor)this.level, (BlockPos)posToGo);
                this.level.setBlock(posToGo, tempState, 67);
                if (tempState.getBlock() instanceof BucketPickup) {
                    ((BucketPickup)tempState.getBlock()).pickupBlock(null, (LevelAccessor)this.level, posToGo, tempState);
                }
                this.level.neighborChanged(posToGo, tempState.getBlock(), posToGo);
                if (tempState.getBlock() instanceof EntityBlock && (blockEntity = this.level.getBlockEntity(posToGoFrom)) != null) {
                    CompoundTag tag = blockEntity.saveWithId((HolderLookup.Provider)this.level.registryAccess());
                    BlockEntity resultEntity = this.level.getBlockEntity(posToGo);
                    if (resultEntity != null) {
                        resultEntity.loadWithComponents(tag, (HolderLookup.Provider)this.level.registryAccess());
                    }
                }
                this.level.removeBlockEntity(posToGoFrom);
                this.level.removeBlock(posToGoFrom, true);
            }
            this.level.playSound(null, this.worldPosition, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 0.8f);
            ++this.progress;
        }
    }

    private void pushEntitiesIfNecessary(BlockPos posToGo, BlockPos pos) {
        List entities = this.level.getEntitiesOfClass(Entity.class, new AABB(posToGo));
        BlockPos vector = posToGo.subtract((Vec3i)pos);
        BlockPos posTo = posToGo.relative(Direction.getNearest((float)vector.getX(), (float)vector.getY(), (float)vector.getZ()));
        for (Entity entity : entities) {
            entity.teleportTo((double)posTo.getX() + 0.5, (double)posTo.getY() + 0.5, (double)posTo.getZ() + 0.5);
        }
    }

    public void rotateAndMirror(RotationMirror rotationMirror) {
        if (this.output != Direction.UP && this.output != Direction.DOWN) {
            this.output = rotationMirror.rotation().rotate(this.output);
        }
        if (this.input != Direction.UP && this.input != Direction.DOWN) {
            this.input = rotationMirror.rotation().rotate(this.input);
        }
        if (this.output != Direction.UP && this.output != Direction.DOWN) {
            this.output = rotationMirror.mirror().mirror(this.output);
        }
        if (this.input != Direction.UP && this.input != Direction.DOWN) {
            this.input = rotationMirror.mirror().mirror(this.input);
        }
    }

    public boolean isOn() {
        return this.on;
    }

    public Direction getInput() {
        return this.input;
    }

    public Direction getOutput() {
        return this.output;
    }

    public void setInput(Direction direction) {
        this.input = direction;
    }

    public void setOutput(Direction output) {
        this.output = output;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = Math.min(range, 10);
        this.progress = range;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = Ints.constrainToRange((int)speed, (int)1, (int)3);
    }

    public void loadAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.range = compound.getInt(TAG_RANGE);
        this.progress = compound.getInt(TAG_PROGRESS);
        this.input = Direction.values()[compound.getInt(TAG_DIRECTION)];
        this.on = compound.getBoolean(TAG_INPUT);
        this.output = compound.getAllKeys().contains(TAG_OUTPUT_DIRECTION) ? Direction.values()[compound.getInt(TAG_OUTPUT_DIRECTION)] : this.input.getOpposite();
        this.speed = compound.getInt(TAG_SPEED);
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt(TAG_RANGE, this.range);
        compound.putInt(TAG_PROGRESS, this.progress);
        compound.putInt(TAG_DIRECTION, this.input.ordinal());
        compound.putBoolean(TAG_INPUT, this.on);
        if (this.output != null) {
            compound.putInt(TAG_OUTPUT_DIRECTION, this.output.ordinal());
        }
        compound.putInt(TAG_SPEED, this.speed);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.loadAdditional(pkt.getTag(), provider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, (HolderLookup.Provider)this.level.registryAccess());
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }
}

