/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.UiRenderMacros;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.util.cursor.Cursor;
import com.ldtteam.blockui.util.cursor.CursorUtils;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.View;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class Pane
extends UiRenderMacros {
    private static final Deque<ScissorsInfo> scissorsInfoStack = new ConcurrentLinkedDeque<ScissorsInfo>();
    protected static Pane lastClickedPane;
    protected static Pane focus;
    protected Pane onHover;
    protected static boolean debugging;
    protected Minecraft mc = Minecraft.getInstance();
    protected String id = "";
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected Alignment alignment = Alignment.TOP_LEFT;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected String onHoverId = "";
    protected Cursor cursor = Cursor.DEFAULT;
    protected BOWindow window;
    protected View parent;
    protected Pane hoverSource = null;
    protected boolean wasCursorInPane = false;
    @Nullable
    private List<MutableComponent> toolTipLines = null;

    public Pane() {
    }

    public Pane(PaneParams params) {
        this.id = params.getString("id", this.id);
        params.getScaledInteger("size", params.getParentWidth(), params.getParentHeight(), a -> {
            this.width = (Integer)a.get(0);
            this.height = (Integer)a.get(1);
        });
        params.getScaledInteger("pos", params.getParentLeft(), params.getParentTop(), a -> {
            this.x = (Integer)a.get(0);
            this.y = (Integer)a.get(1);
        });
        this.alignment = params.getEnum("align", Alignment.class, this.alignment);
        this.visible = params.getBoolean("visible", this.visible);
        this.enabled = params.getBoolean("enabled", this.enabled);
        this.onHoverId = params.getString("onHoverId", this.onHoverId);
        this.toolTipLines = params.getMultilineText("tooltip", this.toolTipLines);
        params.getResource("cursor", resLoc -> {
            this.cursor = "blockui_std".equalsIgnoreCase(resLoc.getNamespace()) ? () -> CursorUtils.setStandardCursor(CursorUtils.StandardCursor.valueOf(resLoc.getPath().toUpperCase())) : Cursor.of(resLoc);
        });
    }

    public static synchronized Pane getFocus() {
        return focus;
    }

    public static void clearFocus() {
        Pane.setFocus(null);
    }

    public void onFocusLost() {
    }

    public void onFocus() {
    }

    public void parseChildren(PaneParams params) {
    }

    public final String getID() {
        return this.id;
    }

    public final void setID(String id) {
        this.id = id;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setPosition(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    public void moveBy(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean shouldDraw() {
        return this.visible || this.hoverSource != null;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void on() {
        this.setEnabled(true);
        this.setVisible(true);
    }

    public void off() {
        this.setEnabled(false);
        this.setVisible(false);
    }

    public final void setFocus() {
        Pane.setFocus(this);
    }

    public final synchronized boolean isFocus() {
        return focus == this;
    }

    public static synchronized void setFocus(Pane f) {
        if (focus != null) {
            focus.onFocusLost();
        }
        if ((focus = f) != null) {
            focus.onFocus();
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public void draw(BOGuiGraphics target, double mx, double my) {
        boolean oldCursorInPane = this.wasCursorInPane;
        this.wasCursorInPane = this.isPointInPane(mx, my);
        this.handleHover(oldCursorInPane);
        if (this.shouldDraw()) {
            if (this.wasCursorInPane && this.isEnabled()) {
                target.setCursor(this.getCursor());
            }
            this.drawSelf(target, mx, my);
            if (debugging) {
                int color = this.wasCursorInPane ? -16711936 : -16776961;
                Pane.drawLineRect(target.pose(), this.x, this.y, this.width, this.height, color);
                if (this.wasCursorInPane && !this.id.isEmpty()) {
                    int stringWidth = this.mc.font.width(this.id) + 1;
                    float f = this.x + this.getWidth() - stringWidth;
                    int n = this.y + this.getHeight();
                    Objects.requireNonNull(this.mc.font);
                    target.drawString(this.id, f, n - 9, color);
                }
            }
        }
    }

    public void drawHidden() {
        boolean oldCursorInPane = this.wasCursorInPane;
        this.wasCursorInPane = false;
        this.handleHover(oldCursorInPane);
    }

    public void drawLast(BOGuiGraphics target, double mx, double my) {
        if (this.shouldDraw()) {
            this.drawSelfLast(target, mx, my);
        }
    }

    public void drawSelf(BOGuiGraphics ms, double mx, double my) {
    }

    public void drawSelfLast(BOGuiGraphics ms, double mx, double my) {
    }

    public boolean isPointInPane(double mx, double my) {
        return this.shouldDraw() && mx >= (double)this.x && mx < (double)(this.x + this.width) && my >= (double)this.y && my < (double)(this.y + this.height);
    }

    public boolean wasCursorInPane() {
        return this.wasCursorInPane;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final <T extends Pane> T findPaneOfTypeByID(String idIn, Class<T> type) {
        @Nullable Pane p = this.findPaneByID(idIn);
        try {
            return (T)((Pane)type.cast(p));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("No pane with id %s and type %s was found.", idIn, type), e);
        }
    }

    public final <T extends Pane> T findFirstPaneByType(Class<T> type) {
        return this.findPaneByType(type);
    }

    @Nullable
    public Pane findPaneByID(String idIn) {
        return this.id.equals(idIn) ? this : null;
    }

    @Nullable
    public <T extends Pane> T findPaneByType(Class<T> type) {
        return (T)(type.isInstance(this) ? (Pane)type.cast(this) : null);
    }

    public final View getParent() {
        return this.parent;
    }

    public final BOWindow getWindow() {
        return this.window;
    }

    public void setWindow(BOWindow w) {
        this.window = w;
        if (this.toolTipLines != null && !this.toolTipLines.isEmpty()) {
            AbstractTextBuilder.TooltipBuilder ttBuilder = PaneBuilders.tooltipBuilder().hoverPane(this);
            this.toolTipLines.forEach(ttBuilder::appendNL);
            this.toolTipLines = null;
            this.onHover = ttBuilder.build();
        }
        this.setHoverPane(this.onHover);
    }

    public void putInside(View newParent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.addChild(this);
            this.setSize(this.width, this.height);
        }
    }

    public boolean isClickable() {
        return this.shouldDraw() && this.isEnabled();
    }

    public boolean click(double mx, double my) {
        Pane.setLastClickedPane(this);
        return this.handleClick(mx - (double)this.x, my - (double)this.y);
    }

    public boolean rightClick(double mx, double my) {
        Pane.setLastClickedPane(this);
        return this.handleRightClick(mx - (double)this.x, my - (double)this.y);
    }

    private static synchronized void setLastClickedPane(Pane pane) {
        lastClickedPane = pane;
    }

    public boolean handleClick(double mx, double my) {
        return false;
    }

    public boolean handleRightClick(double mx, double my) {
        return false;
    }

    public boolean canHandleClick(double mx, double my) {
        return this.shouldDraw() && this.isEnabled() && this.isPointInPane(mx, my);
    }

    public boolean onKeyTyped(char ch, int key) {
        return false;
    }

    public void onUpdate() {
    }

    protected synchronized void scissorsStart(PoseStack ms, int contentWidth, int contentHeight) {
        int fbWidth = this.mc.getWindow().getWidth();
        int fbHeight = this.mc.getWindow().getHeight();
        Vector4f start = new Vector4f((float)this.x, (float)this.y, 0.0f, 1.0f);
        Vector4f end = new Vector4f((float)(this.x + this.width), (float)(this.y + this.height), 0.0f, 1.0f);
        ms.last().pose().transform(start);
        ms.last().pose().transform(end);
        int scissorsXstart = Mth.clamp((int)((int)Math.floor(start.x())), (int)0, (int)fbWidth);
        int scissorsXend = Mth.clamp((int)((int)Math.floor(end.x())), (int)0, (int)fbWidth);
        int scissorsYstart = Mth.clamp((int)((int)Math.floor(start.y())), (int)0, (int)fbHeight);
        int scissorsYend = Mth.clamp((int)((int)Math.floor(end.y())), (int)0, (int)fbHeight);
        int temp = scissorsYstart;
        scissorsYstart = fbHeight - scissorsYend;
        scissorsYend = fbHeight - temp;
        if (!scissorsInfoStack.isEmpty()) {
            ScissorsInfo parentInfo = scissorsInfoStack.peek();
            scissorsXstart = Math.max(scissorsXstart, parentInfo.xStart);
            scissorsXend = Math.max(scissorsXstart, Math.min(parentInfo.xEnd, scissorsXend));
            scissorsYstart = Math.max(scissorsYstart, parentInfo.yStart);
            scissorsYend = Math.max(scissorsYstart, Math.min(parentInfo.yEnd, scissorsYend));
        }
        ScissorsInfo info = new ScissorsInfo(scissorsXstart, scissorsXend, scissorsYstart, scissorsYend, this.window.getScreen().width, this.window.getScreen().height);
        scissorsInfoStack.push(info);
        this.window.getScreen().width = contentWidth;
        this.window.getScreen().height = contentHeight;
        RenderSystem.enableScissor((int)scissorsXstart, (int)scissorsYstart, (int)(scissorsXend - scissorsXstart), (int)(scissorsYend - scissorsYstart));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    protected synchronized void scissorsEnd(BOGuiGraphics target) {
        PoseStack ms = target.pose();
        ScissorsInfo popped = scissorsInfoStack.pop();
        if (debugging) {
            int color = -65536;
            int w = popped.xEnd - popped.xStart;
            int h = popped.yEnd - popped.yStart;
            int yStart = this.mc.getWindow().getHeight() - popped.yEnd;
            ms.pushPose();
            ms.setIdentity();
            Pane.drawLineRect(ms, popped.xStart, yStart, w, h, -65536, 2);
            String scId = "scissor_" + (this.id.isEmpty() ? this.toString() : this.id);
            int stringWidth = this.mc.font.width(scId) + 1;
            float f = popped.xStart + w - stringWidth;
            Objects.requireNonNull(this.mc.font);
            target.drawString(scId, f, yStart + h - 2 * 9, -65536);
            ms.popPose();
        }
        this.window.getScreen().width = popped.oldGuiWidth;
        this.window.getScreen().height = popped.oldGuiHeight;
        if (!scissorsInfoStack.isEmpty()) {
            ScissorsInfo info = scissorsInfoStack.peek();
            RenderSystem.enableScissor((int)info.xStart, (int)info.yStart, (int)(info.xEnd - info.xStart), (int)(info.yEnd - info.yStart));
        } else {
            RenderSystem.disableScissor();
        }
    }

    public boolean scrollInput(double horizontalWheel, double verticalWheel, double mx, double my) {
        return false;
    }

    public void setParentView(View view) {
        this.parent = view;
    }

    protected void handleHover(boolean wasCursorInPaneLastTick) {
        if (this.onHover == null && !this.onHoverId.isEmpty()) {
            this.onHover = this.window.findPaneByID(this.onHoverId);
            Objects.requireNonNull(this.onHover, String.format("Hover pane \"%s\" for \"%s\" was not found.", this.onHoverId, this.id));
            this.onHover.hide();
        }
        if (this.onHover != null && this.wasCursorInPane && this.onHover.hoverSource == null && this.onHover.isEnabled()) {
            this.onHover.hoverSource = this;
        } else if (!this.wasCursorInPane && !wasCursorInPaneLastTick) {
            if (this.onHover != null && this.onHover.hoverSource == this && !this.onHover.wasCursorInPane) {
                this.onHover.hoverSource = null;
            } else if (this.hoverSource != null && !this.hoverSource.wasCursorInPane) {
                this.hoverSource = null;
            }
        }
    }

    public Pane setHoverPane(Pane hoverPane) {
        if (this.onHover != null) {
            this.onHover.putInside(null);
        }
        Pane oldHover = this.onHover;
        this.onHover = hoverPane;
        if (this.onHover != null) {
            this.onHover.putInside(this.window);
        }
        return oldHover;
    }

    public Pane getHoverPane() {
        return this.onHover;
    }

    public boolean onMouseDrag(double mx, double my, int speed, double deltaX, double deltaY) {
        return false;
    }

    static {
        debugging = false;
    }

    private static class ScissorsInfo {
        private final int xStart;
        private final int yStart;
        private final int xEnd;
        private final int yEnd;
        private final int oldGuiWidth;
        private final int oldGuiHeight;

        ScissorsInfo(int xStart, int xEnd, int yStart, int yEnd, int oldGuiWidth, int oldGuiHeight) {
            this.xStart = xStart;
            this.xEnd = xEnd;
            this.yStart = yStart;
            this.yEnd = yEnd;
            this.oldGuiWidth = oldGuiWidth;
            this.oldGuiHeight = oldGuiHeight;
        }
    }
}

