/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.hooks;

import com.google.common.base.Predicates;
import com.ldtteam.blockui.hooks.HookManager;
import com.ldtteam.blockui.hooks.IGuiActionCallback;
import com.ldtteam.blockui.hooks.IGuiHookable;
import com.ldtteam.blockui.hooks.TriggerMechanism;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public final class HookRegistries {
    public static final EntityReg ENTITY_HOOKS = new EntityReg();
    public static final BlockEntityReg BLOCK_ENTITY_HOOKS = new BlockEntityReg();
    private static final HookManager<?, ?, ?>[] REGISTRIES = new HookManager[]{BLOCK_ENTITY_HOOKS, ENTITY_HOOKS};

    public static void tick(long ticks) {
        for (int i = 0; i < REGISTRIES.length; ++i) {
            REGISTRIES[i].tick(ticks);
        }
    }

    public static void render(PoseStack matrixStack, float partialTicks) {
        for (int i = 0; i < REGISTRIES.length; ++i) {
            REGISTRIES[i].render(matrixStack, partialTicks);
        }
    }

    public static class EntityReg
    extends HookManager<Entity, EntityType<?>, Entity> {
        private EntityReg() {
            super(BuiltInRegistries.ENTITY_TYPE);
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism trigger) {
            this.register(targetThing, guiLoc, 0L, trigger);
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger) {
            this.register(targetThing, guiLoc, expirationTime, trigger, (rec$, x$0) -> ((IGuiHookable)rec$).shouldOpen((TriggerMechanism)x$0), (rec$, x$0, x$1) -> ((IGuiHookable)rec$).onOpen(x$0, x$1), (rec$, x$0, x$1) -> ((IGuiHookable)rec$).onClose(x$0, x$1));
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism trigger, @Nullable BiPredicate<T, TriggerMechanism> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.register(targetThing, guiLoc, 0L, trigger, shouldOpen, onOpen, onClose);
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger, @Nullable BiPredicate<T, TriggerMechanism> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.registerInternal(targetThing, guiLoc, expirationTime, trigger, shouldOpen, onOpen, onClose);
        }

        @Override
        protected List<? extends Entity> findTriggered(EntityType<?> entityType, TriggerMechanism trigger) {
            Minecraft mc = Minecraft.getInstance();
            TriggerMechanism triggerMechanism = trigger;
            Objects.requireNonNull(triggerMechanism);
            TriggerMechanism triggerMechanism2 = triggerMechanism;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TriggerMechanism.RangeTriggerMechanism.class, TriggerMechanism.RayTraceTriggerMechanism.class}, (Object)triggerMechanism2, n)) {
                case 0 -> {
                    TriggerMechanism.RangeTriggerMechanism range = (TriggerMechanism.RangeTriggerMechanism)triggerMechanism2;
                    yield mc.level.getEntities(entityType, mc.player.getBoundingBox().inflate(range.getSearchRange()), (Predicate)Predicates.alwaysTrue());
                }
                case 1 -> {
                    EntityHitResult entityHitResult;
                    Entity entity;
                    HitResult var9_8;
                    TriggerMechanism.RayTraceTriggerMechanism rayTrace = (TriggerMechanism.RayTraceTriggerMechanism)triggerMechanism2;
                    if (mc.hitResult != null && (var9_8 = mc.hitResult) instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)var9_8).getEntity()).getType() == entityType) {
                        yield Arrays.asList(entity);
                    }
                    yield Collections.emptyList();
                }
                default -> throw new IllegalArgumentException("No trigger mechanism for Entity and " + trigger.getName() + " trigger.");
            };
        }

        @Override
        protected Entity keyMapper(Entity thing) {
            return thing;
        }

        @Override
        protected void translateToGuiBottomCenter(PoseStack ms, Entity entity, float partialTicks) {
            double x = Mth.lerp((double)partialTicks, (double)entity.xOld, (double)entity.getX());
            double y = Mth.lerp((double)partialTicks, (double)entity.yOld, (double)entity.getY());
            double z = Mth.lerp((double)partialTicks, (double)entity.zOld, (double)entity.getZ());
            ms.translate(x, y + (double)entity.getBbHeight() + 0.3, z);
        }
    }

    public static class BlockEntityReg
    extends HookManager<BlockEntity, BlockEntityType<?>, BlockPos> {
        private BlockEntityReg() {
            super(BuiltInRegistries.BLOCK_ENTITY_TYPE);
        }

        public <T extends BlockEntity> void register(BlockEntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism trigger) {
            this.register(targetThing, guiLoc, 0L, trigger);
        }

        public <T extends BlockEntity> void register(BlockEntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger) {
            this.register(targetThing, guiLoc, expirationTime, trigger, (rec$, x$0) -> ((IGuiHookable)rec$).shouldOpen((TriggerMechanism)x$0), (rec$, x$0, x$1) -> ((IGuiHookable)rec$).onOpen(x$0, x$1), (rec$, x$0, x$1) -> ((IGuiHookable)rec$).onClose(x$0, x$1));
        }

        public <T extends BlockEntity> void register(BlockEntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism trigger, @Nullable BiPredicate<T, TriggerMechanism> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.register(targetThing, guiLoc, 0L, trigger, shouldOpen, onOpen, onClose);
        }

        public <T extends BlockEntity> void register(BlockEntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger, @Nullable BiPredicate<T, TriggerMechanism> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.registerInternal(targetThing, guiLoc, expirationTime, trigger, shouldOpen, onOpen, onClose);
        }

        @Override
        protected List<BlockEntity> findTriggered(BlockEntityType<?> teType, TriggerMechanism trigger) {
            Minecraft mc = Minecraft.getInstance();
            TriggerMechanism triggerMechanism = trigger;
            Objects.requireNonNull(triggerMechanism);
            TriggerMechanism triggerMechanism2 = triggerMechanism;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TriggerMechanism.RangeTriggerMechanism.class, TriggerMechanism.RayTraceTriggerMechanism.class}, (Object)triggerMechanism2, n)) {
                case 0 -> {
                    TriggerMechanism.RangeTriggerMechanism range = (TriggerMechanism.RangeTriggerMechanism)triggerMechanism2;
                    AABB aabb = mc.player.getBoundingBox().inflate(range.getSearchRange());
                    int xStart = Mth.floor((double)(aabb.minX / 16.0));
                    int xEnd = Mth.ceil((double)(aabb.maxX / 16.0));
                    int zStart = Mth.floor((double)(aabb.minZ / 16.0));
                    int zEnd = Mth.ceil((double)(aabb.maxZ / 16.0));
                    ArrayList<BlockEntity> targets = new ArrayList<BlockEntity>();
                    for (int chunkX = xStart; chunkX < xEnd; ++chunkX) {
                        for (int chunkZ = zStart; chunkZ < zEnd; ++chunkZ) {
                            LevelChunk chunk = mc.level.getChunkSource().getChunk(chunkX, chunkZ, false);
                            if (chunk == null) continue;
                            for (Map.Entry entry : chunk.getBlockEntities().entrySet()) {
                                BlockPos bp = (BlockPos)entry.getKey();
                                BlockEntity te = (BlockEntity)entry.getValue();
                                if (te.getType() != teType || !((double)bp.getX() > aabb.minX) || !((double)bp.getX() < aabb.maxX) || !((double)bp.getY() > aabb.minY) || !((double)bp.getY() < aabb.maxY) || !((double)bp.getZ() > aabb.minZ) || !((double)bp.getZ() < aabb.maxZ)) continue;
                                targets.add(te);
                            }
                        }
                    }
                    yield targets;
                }
                case 1 -> {
                    BlockHitResult blockHitResult;
                    BlockEntity te;
                    HitResult xEnd;
                    TriggerMechanism.RayTraceTriggerMechanism rayTrace = (TriggerMechanism.RayTraceTriggerMechanism)triggerMechanism2;
                    if (mc.hitResult != null && (xEnd = mc.hitResult) instanceof BlockHitResult && (te = mc.level.getBlockEntity((blockHitResult = (BlockHitResult)xEnd).getBlockPos())) != null && te.getType() == teType) {
                        yield Arrays.asList(te);
                    }
                    yield Collections.emptyList();
                }
                default -> throw new IllegalArgumentException("No trigger mechanism for BlockEntity and " + trigger.getName() + " trigger.");
            };
        }

        @Override
        protected BlockPos keyMapper(BlockEntity thing) {
            return thing.getBlockPos();
        }

        @Override
        protected void translateToGuiBottomCenter(PoseStack ms, BlockEntity thing, float partialTicks) {
            ms.translate((double)thing.getBlockPos().getX() + 0.5, (double)thing.getBlockPos().getY() + 1.1, (double)thing.getBlockPos().getZ() + 0.5);
        }
    }
}

