/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.texture;

import com.ldtteam.blockui.UiRenderMacros;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.resources.ResourceLocation;

public record ResolvedWidgetSprites(UiRenderMacros.ResolvedBlit enabled, UiRenderMacros.ResolvedBlit disabled, UiRenderMacros.ResolvedBlit enabledFocused, UiRenderMacros.ResolvedBlit disabledFocused) {
    public static float FOCUSED_MODULATOR = 1.1f;
    public static float DISABLED_MODULATOR = 0.5f;
    public static float DISABLED_FOCUSED_MODULATOR = 0.6f;

    public static ResolvedWidgetSprites fromUnresolved(WidgetSprites widgetSprites, Function<ResourceLocation, UiRenderMacros.ResolvedBlit> resolver) {
        HashMap<ResourceLocation, UiRenderMacros.ResolvedBlit> resolved = new HashMap<ResourceLocation, UiRenderMacros.ResolvedBlit>();
        UiRenderMacros.ResolvedBlit defaultEnabledBlit = resolver.apply(Objects.requireNonNull(widgetSprites.enabled(), "Forgot to put null check somewhere?"));
        resolved.put(null, defaultEnabledBlit);
        resolved.put(widgetSprites.enabled(), defaultEnabledBlit);
        return new ResolvedWidgetSprites(defaultEnabledBlit, resolved.computeIfAbsent(widgetSprites.disabled(), resolver), resolved.computeIfAbsent(widgetSprites.enabledFocused(), resolver), resolved.computeIfAbsent(widgetSprites.disabledFocused(), resolver));
    }

    public UiRenderMacros.ResolvedBlit getAndPrepare(boolean isEnabled, boolean isFocused) {
        if (isEnabled) {
            if (isFocused) {
                ResolvedWidgetSprites.ifSameShaderColor(this.enabled, this.enabledFocused, FOCUSED_MODULATOR);
                return this.enabledFocused;
            }
            return this.enabled;
        }
        if (isFocused) {
            ResolvedWidgetSprites.ifSameShaderColor(this.enabled, this.disabledFocused, DISABLED_MODULATOR);
            return this.disabledFocused;
        }
        ResolvedWidgetSprites.ifSameShaderColor(this.enabled, this.disabled, DISABLED_MODULATOR);
        return this.disabled;
    }

    private static void ifSameShaderColor(UiRenderMacros.ResolvedBlit a, UiRenderMacros.ResolvedBlit b, float rgb) {
        if (a == b) {
            RenderSystem.setShaderColor((float)rgb, (float)rgb, (float)rgb, (float)1.0f);
        }
    }
}

