/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.views.ScrollingView;

public class ScrollingGroup
extends ScrollingView {
    protected int childSpacing = 0;

    public ScrollingGroup() {
    }

    public ScrollingGroup(PaneParams params) {
        super(params);
        this.childSpacing = params.getInteger("childspacing", this.childSpacing);
    }

    @Override
    public void parseChildren(PaneParams params) {
        this.container.parseChildren(params);
        for (int i = 1; i < this.container.children.size(); ++i) {
            Pane child = (Pane)this.container.children.get(i);
            Pane lastChild = (Pane)this.container.children.get(i - 1);
            int childY = lastChild.getY() + lastChild.getHeight() + this.childSpacing;
            child.setPosition(0, childY);
        }
        this.container.computeContentHeight();
    }

    @Override
    public void adjustChild(Pane child) {
        int childY = 0;
        if (this.children.size() >= 2) {
            Pane lastChild = (Pane)this.children.get(this.children.size() - 2);
            childY = lastChild.getY() + lastChild.getHeight() + this.childSpacing;
        }
        child.setPosition(0, childY);
    }

    @Override
    public void removeChild(Pane child) {
        super.removeChild(child);
        int formerChildY = child.getY();
        int formerChildHeight = child.getHeight() + this.childSpacing;
        for (Pane c : this.children) {
            if (c.getY() <= formerChildY) continue;
            c.moveBy(0, -formerChildHeight);
        }
    }
}

