/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.keybinds.room;

import com.mojang.blaze3d.platform.InputConstants;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.feature.CMFeatureFlags;
import dev.compactmods.machines.network.room.PlayerRequestedUpgradeUIPacket;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.network.PacketDistributor;

public class RoomUpgradeUIMapping {
    public static final String CATEGORY = Util.makeDescriptionId((String)"key.category", (ResourceLocation)CompactMachines.modRL((String)"general"));
    public static final String NAME = Util.makeDescriptionId((String)"key.mapping", (ResourceLocation)CompactMachines.modRL((String)"open_upgrade_screen"));
    public static final IKeyConflictContext CONFLICT_CONTEXT = new IKeyConflictContext(){

        public boolean isActive() {
            ClientLevel level = Minecraft.getInstance().level;
            return level != null && level.dimension().equals(CompactDimension.LEVEL_KEY);
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    };
    public static final KeyMapping MAPPING = new KeyMapping(NAME, CONFLICT_CONTEXT, InputConstants.UNKNOWN, CATEGORY);

    public static void handle() {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && level != null && level.dimension().equals(CompactDimension.LEVEL_KEY)) {
            if (CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(level.enabledFeatures())) {
                player.getExistingData(CMDataAttachments.CURRENT_ROOM_CODE).ifPresent(currentRoom -> PacketDistributor.sendToServer((CustomPacketPayload)new PlayerRequestedUpgradeUIPacket((String)currentRoom, true), (CustomPacketPayload[])new CustomPacketPayload[0]));
            } else {
                player.displayClientMessage((Component)Component.literal((String)"You must enable room components for this keybind!"), true);
            }
        }
    }
}

