/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.room.template.RoomTemplate;
import dev.compactmods.machines.api.room.template.RoomTemplateHelper;
import dev.compactmods.machines.command.argument.Suggestors;
import dev.compactmods.machines.i18n.CommandTranslations;
import dev.compactmods.machines.i18n.RoomTranslations;
import dev.compactmods.machines.machine.Machines;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Logger;

public class CMGiveMachineSubcommand {
    private static final Logger LOGGER = LoggingUtil.modLog();

    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = (LiteralArgumentBuilder)Commands.literal((String)"give").requires(cs -> cs.hasPermission(2));
        subRoot.then(Commands.literal((String)"new").then(Commands.argument((String)"template", (ArgumentType)ResourceLocationArgument.id()).suggests(Suggestors.ROOM_TEMPLATES).executes(CMGiveMachineSubcommand::giveNewMachineExecutor)));
        subRoot.then(Commands.literal((String)"existing").then(Commands.argument((String)"room", (ArgumentType)StringArgumentType.string()).suggests(Suggestors.ROOM_CODES).executes(CMGiveMachineSubcommand::giveExistingRoomExecutor)));
        RequiredArgumentBuilder giveSpecificPlayer = Commands.argument((String)"player", (ArgumentType)EntityArgument.player());
        giveSpecificPlayer.then(Commands.literal((String)"new").then(Commands.argument((String)"template", (ArgumentType)ResourceLocationArgument.id()).suggests(Suggestors.ROOM_TEMPLATES).executes(CMGiveMachineSubcommand::giveNewMachineSpecificPlayer)));
        giveSpecificPlayer.then(Commands.literal((String)"existing").then(Commands.argument((String)"room", (ArgumentType)StringArgumentType.string()).suggests(Suggestors.ROOM_CODES).executes(CMGiveMachineSubcommand::giveExistingRoomSpecificPlayer)));
        subRoot.then((ArgumentBuilder)giveSpecificPlayer);
        return subRoot;
    }

    private static int giveNewMachineExecutor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = src.getPlayerOrException();
        ResourceLocation templateId = ResourceLocationArgument.getId(ctx, (String)"template");
        CMGiveMachineSubcommand.createAndGiveNewMachine(src, templateId, player);
        return 0;
    }

    private static int giveNewMachineSpecificPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        ResourceLocation templateId = ResourceLocationArgument.getId(ctx, (String)"template");
        CMGiveMachineSubcommand.createAndGiveNewMachine(src, templateId, player);
        return 0;
    }

    private static int giveExistingRoomExecutor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = src.getPlayerOrException();
        String roomCode = StringArgumentType.getString(ctx, (String)"room");
        CMGiveMachineSubcommand.createAndGiveExistingRoom(roomCode, player, src);
        return 0;
    }

    private static int giveExistingRoomSpecificPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        String roomCode = StringArgumentType.getString(ctx, (String)"room");
        CMGiveMachineSubcommand.createAndGiveExistingRoom(roomCode, player, src);
        return 0;
    }

    private static void createAndGiveNewMachine(CommandSourceStack src, ResourceLocation templateId, ServerPlayer player) {
        Holder.Reference template = RoomTemplateHelper.getTemplateHolder((RegistryAccess)src.getServer().registryAccess(), (ResourceLocation)templateId);
        if (template.isBound()) {
            ItemStack item = Machines.Items.forNewRoom((Holder.Reference<RoomTemplate>)template);
            if (!player.addItem(item)) {
                src.sendFailure(CommandTranslations.CANNOT_GIVE_MACHINE.get());
            } else {
                src.sendSuccess(() -> CommandTranslations.MACHINE_GIVEN.apply((Player)player), true);
            }
        } else {
            src.sendFailure(CommandTranslations.CANNOT_GIVE_MACHINE.get());
        }
    }

    private static void createAndGiveExistingRoom(String roomCode, ServerPlayer player, CommandSourceStack src) {
        CompactMachines.room((String)roomCode).ifPresentOrElse(room -> {
            ItemStack newItem = Machines.Items.boundToRoom(room.code(), room.defaultMachineColor());
            if (!player.addItem(newItem)) {
                src.sendFailure(CommandTranslations.CANNOT_GIVE_MACHINE.get());
            } else {
                src.sendSuccess(() -> CommandTranslations.MACHINE_GIVEN.apply((Player)player), true);
            }
        }, () -> {
            LOGGER.error("Error giving player a new machine block: room not found.");
            src.sendFailure(RoomTranslations.UNKNOWN_ROOM_BY_CODE.apply(roomCode));
        });
    }
}

