/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.i18n.Translations;
import dev.compactmods.machines.network.room.SyncRoomMetadataPacket;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;

public class RoomEventHandler {
    private static final Logger LOGS = LoggingUtil.modLog();

    public static void entityChangedDimensions(EntityTravelToDimensionEvent dimensionEvent) {
        Entity ent = dimensionEvent.getEntity();
        if (!(ent instanceof Player)) {
            return;
        }
        Player p = (Player)ent;
        if (!CompactDimension.isLevelCompact((ResourceKey)dimensionEvent.getDimension()) && p instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)p;
            LOGS.debug("Resetting player {}'s room history due to dimension change.", (Object)sp.getGameProfile().getName());
            PlayerUtil.resetPlayerHistory(sp);
        }
    }

    public static void entityJoined(EntityJoinLevelEvent evt) {
        Entity ent = evt.getEntity();
        if (!CompactDimension.isLevelCompact((Level)ent.level()) || ent.level().isClientSide) {
            return;
        }
        if (ent instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)ent;
            CompactMachines.chunkManager().findRoomByChunk(serverPlayer.chunkPosition()).flatMap(CompactMachines::room).ifPresent(room -> PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncRoomMetadataPacket(room.code(), (UUID)room.getData(CMDataAttachments.ROOM_OWNER)), (CustomPacketPayload[])new CustomPacketPayload[0]));
        } else if (!RoomEventHandler.positionInsideRoom(ent, ent.position())) {
            evt.setCanceled(true);
        }
    }

    public static void checkSpawn(FinalizeSpawnEvent evt) {
        Vec3 target = new Vec3(evt.getX(), evt.getY(), evt.getZ());
        Mob ent = evt.getEntity();
        if (!CompactDimension.isLevelCompact((Level)ent.level())) {
            return;
        }
        if (!RoomEventHandler.positionInsideRoom((Entity)ent, target)) {
            evt.setSpawnCancelled(true);
        }
    }

    public static void entityTeleport(EntityTeleportEvent evt) {
        if (evt instanceof EntityTeleportEvent.TeleportCommand) {
            return;
        }
        if (!evt.getEntity().level().dimension().equals(CompactDimension.LEVEL_KEY)) {
            return;
        }
        Entity ent = evt.getEntity();
        RoomEventHandler.doEntityTeleportHandle(evt, evt.getTarget(), ent);
    }

    private static boolean positionInsideRoom(Entity entity, Vec3 target) {
        if (!CompactDimension.isLevelCompact((Level)entity.level())) {
            return false;
        }
        return CompactMachines.chunkManager().findRoomByChunk(entity.chunkPosition()).flatMap(CompactMachines::room).map(ib -> ib.boundaries().innerBounds().contains(target)).orElse(false);
    }

    private static void doEntityTeleportHandle(EntityTeleportEvent evt, Vec3 target, Entity ent) {
        if (!RoomEventHandler.positionInsideRoom(ent, target)) {
            if (ent instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)ent;
                sp.displayClientMessage(Translations.TELEPORT_OUT_OF_BOUNDS.get(), true);
            }
            evt.setCanceled(true);
        }
    }
}

