/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.ui.upgrades;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.client.render.ConditionalGhostSlot;
import dev.compactmods.machines.client.render.NineSliceRenderer;
import dev.compactmods.machines.client.widget.ImageButtonBuilder;
import dev.compactmods.machines.network.room.PlayerRequestedRoomUIPacket;
import dev.compactmods.machines.room.ui.upgrades.RoomUpgradeMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoomUpgradeScreen
extends AbstractContainerScreen<RoomUpgradeMenu> {
    WidgetSprites BACK_BTN_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward_highlighted"));
    private final NineSliceRenderer backgroundRenderer;

    public RoomUpgradeScreen(RoomUpgradeMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.titleLabelY = 6;
        this.inventoryLabelY = 58;
        this.imageHeight = 152;
        this.backgroundRenderer = NineSliceRenderer.builder(CompactMachines.modRL((String)"textures/gui/psd_screen_9slice.png")).area(0, 0, this.imageWidth, this.imageHeight).uv(32, 32).sliceSize(4, 4).textureSize(32, 32).build();
    }

    protected void init() {
        super.init();
        if (((RoomUpgradeMenu)this.menu).showBackButton) {
            ImageButton backButton = ImageButtonBuilder.button(this.BACK_BTN_SPRITES).location(this.leftPos - 12, this.topPos + 2).size(8, 12).message((Component)Component.literal((String)"Close")).onPress(button -> PacketDistributor.sendToServer((CustomPacketPayload)new PlayerRequestedRoomUIPacket(((RoomUpgradeMenu)this.menu).roomCode), (CustomPacketPayload[])new CustomPacketPayload[0])).build();
            this.addRenderableWidget((GuiEventListener)backButton);
        }
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int white = DyeColor.WHITE.getTextColor();
        pGuiGraphics.drawString(this.font, (Component)Component.literal((String)"Room Upgrades"), this.titleLabelX, this.titleLabelY, white, false);
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, white, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)this.leftPos, (float)this.topPos, 0.0f);
        this.backgroundRenderer.render(graphics);
        pose.popPose();
        pose.pushPose();
        pose.translate((float)this.leftPos, (float)this.topPos, 100.0f);
        for (Slot i : ((RoomUpgradeMenu)this.menu).slots) {
            graphics.fill(i.x, i.y, i.x + 16, i.y + 16, 0xF000000);
        }
        pose.popPose();
    }

    public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(graphics, pMouseX, pMouseY);
    }

    protected void renderSlotContents(GuiGraphics guiGraphics, ItemStack itemstack, Slot slot, @Nullable String countString) {
        if (slot instanceof ConditionalGhostSlot) {
            this.renderGhostSlot(guiGraphics, itemstack, slot, countString);
            return;
        }
        super.renderSlotContents(guiGraphics, itemstack, slot, countString);
    }

    private void renderGhostSlot(@NotNull GuiGraphics graphics, @NotNull ItemStack itemstack, @NotNull Slot slot, @Nullable String countString) {
        graphics.renderItem(slot.getItem(), slot.x, slot.y);
        graphics.fill(RenderType.guiGhostRecipeOverlay(), slot.x, slot.y, slot.x + 16, slot.y + 16, FastColor.ARGB32.color((int)150, (int)30, (int)70, (int)210));
        if (!itemstack.isEmpty()) {
            graphics.pose().pushPose();
            if (itemstack.getCount() != 1 || countString != null) {
                String s = countString == null ? String.valueOf(itemstack.getCount()) : countString;
                graphics.pose().translate(0.0f, 0.0f, 200.0f);
                graphics.drawString(this.font, s, slot.x + 19 - 2 - this.font.width(s), slot.y + 6 + 3, FastColor.ARGB32.color((int)120, (int)255, (int)255, (int)255), false);
            }
            graphics.pose().popPose();
        }
    }
}

