/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.upgrade.example;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeComponent;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeComponentType;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeInstance;
import dev.compactmods.machines.api.room.upgrade.event.RoomUpgradeComponentEvent;
import dev.compactmods.machines.api.room.upgrade.event.lifecycle.UpgradeTickedEventListener;
import dev.compactmods.machines.room.upgrade.RoomUpgrades;
import dev.compactmods.machines.util.item.ItemHandlerUtil;
import dev.compactmods.spatial.aabb.AABBHelper;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;

public class TreeCutterUpgradeComponent
implements RoomUpgradeComponent {
    public static final MapCodec<TreeCutterUpgradeComponent> CODEC = MapCodec.unit(TreeCutterUpgradeComponent::new);
    public static final Supplier<AttachmentType<Data>> TREECUTTER_DATA = CMDataAttachments.ATTACHMENT_TYPES.register("treecutter", key -> AttachmentType.builder(() -> new Data()).serialize(Data.CODEC).build());

    public static void prepare() {
    }

    public void addToTooltip(@NotNull Item.TooltipContext ctx, Consumer<Component> tooltips, @NotNull TooltipFlag flags) {
        MutableComponent c = Component.literal((String)"Tree Cutter").withColor(-6250336);
        tooltips.accept((Component)c);
    }

    public Stream<RoomUpgradeComponentEvent> gatherEvents() {
        UpgradeTickedEventListener ticker = TreeCutterUpgradeComponent::onTick;
        return Stream.of(ticker);
    }

    public RoomUpgradeComponentType<TreeCutterUpgradeComponent> getType() {
        return (RoomUpgradeComponentType)RoomUpgrades.TREECUTTER.get();
    }

    public static void onTick(RoomUpgradeInstance instance) {
        Data data = (Data)instance.getData(TREECUTTER_DATA);
        if (data.cooldown > 0) {
            --data.cooldown;
            return;
        }
        RoomInstance room = instance.roomInstance();
        ServerLevel level = room.level();
        boolean everythingLoaded = room.boundaries().innerChunkPositions().allMatch(cp -> level.shouldTickBlocksAt(cp.toLong()));
        if (!everythingLoaded) {
            data.cooldown = 200;
            return;
        }
        AABB innerBounds = room.boundaries().innerBounds();
        ItemStack upgradeItem = instance.upgradeItem();
        IEnergyStorage energyHandler = (IEnergyStorage)upgradeItem.getCapability(Capabilities.EnergyStorage.ITEM);
        boolean doItemDamage = false;
        boolean preferEnergy = false;
        int maxAllowed = 0;
        if (upgradeItem.isDamageableItem()) {
            doItemDamage = true;
            int durabilityLeft = upgradeItem.getMaxDamage() - upgradeItem.getDamageValue();
            maxAllowed = Math.clamp((long)durabilityLeft, 0, 5);
        }
        if (energyHandler != null && energyHandler.canExtract()) {
            doItemDamage = true;
            preferEnergy = true;
            maxAllowed = Math.clamp((long)(energyHandler.getEnergyStored() / 10), 0, 10);
        }
        Set treeBlocks = BlockPos.betweenClosedStream((AABB)innerBounds).map(pos -> {
            BlockState state = level.getBlockState(pos);
            return Pair.of((Object)pos.immutable(), (Object)state);
        }).filter(pair -> {
            BlockState state = (BlockState)pair.right();
            if (state.is(BlockTags.LOGS)) {
                return true;
            }
            if (state.is(BlockTags.LEAVES)) {
                if (state.hasProperty((Property)LeavesBlock.PERSISTENT)) {
                    return (Boolean)state.getValue((Property)LeavesBlock.PERSISTENT) == false;
                }
                return true;
            }
            return false;
        }).limit(maxAllowed).collect(Collectors.toUnmodifiableSet());
        int numLogs = treeBlocks.size();
        if (!treeBlocks.isEmpty()) {
            AABB bounds = room.boundaries().innerBounds();
            Vector3dc minCorner = AABBHelper.minCorner((AABB)bounds);
            BlockPos lastDitch = BlockPos.containing((double)minCorner.x(), (double)(minCorner.y() + 1.0), (double)minCorner.z());
            List<LocatedInventory> inventories = TreeCutterUpgradeComponent.getInventories(level, bounds).toList();
            if (inventories.isEmpty()) {
                return;
            }
            for (Pair pos2 : treeBlocks) {
                BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos2.left());
                List drops = Block.getDrops((BlockState)((BlockState)pos2.right()), (ServerLevel)level, (BlockPos)((BlockPos)pos2.left()), (BlockEntity)blockEntity, null, (ItemStack)upgradeItem);
                level.destroyBlock((BlockPos)pos2.left(), false);
                if (drops.isEmpty()) continue;
                List<Object> remaining = new ArrayList();
                for (LocatedInventory locatedInventory : inventories) {
                    remaining = ItemHandlerUtil.insertMultipleStacks(locatedInventory.inventory, drops);
                    if (!remaining.isEmpty()) continue;
                    break;
                }
                if (remaining.isEmpty()) continue;
                for (ItemStack itemStack : remaining) {
                    Block.popResource((Level)level, (BlockPos)lastDitch, (ItemStack)itemStack);
                }
            }
            if (preferEnergy) {
                energyHandler.extractEnergy(numLogs * 10, false);
            } else if (doItemDamage) {
                upgradeItem.hurtAndBreak(numLogs, level, null, item -> upgradeItem.shrink(1));
            }
        }
        data.cooldown = 1;
    }

    private static Stream<LocatedInventory> getInventories(ServerLevel level, AABB bounds) {
        return AABBHelper.allCorners((AABB)bounds).map(BlockPos::immutable).flatMap(pos -> Stream.of((IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null), (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.UP)).filter(Objects::nonNull).map(handler -> new LocatedInventory((BlockPos)pos, (IItemHandler)handler)));
    }

    public static class Data {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("cooldown").forGetter(d -> d.cooldown)).apply((Applicative)i, Data::new));
        public int cooldown;

        public Data() {
            this.cooldown = 0;
        }

        Data(int cooldown) {
            this.cooldown = cooldown;
        }
    }

    private record LocatedInventory(BlockPos pos, IItemHandler inventory) {
    }
}

