/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.ChunkChangeResponsePacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public record RequestChunkChangePacket(ChunkChangeOp action, Set<XZ> chunks, boolean tryAdminChanges, Optional<UUID> teamId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestChunkChangePacket> TYPE = new CustomPacketPayload.Type(FTBChunksAPI.rl("request_chunk_change_packet"));
    public static final StreamCodec<FriendlyByteBuf, RequestChunkChangePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)NetworkHelper.enumStreamCodec(ChunkChangeOp.class), RequestChunkChangePacket::action, (StreamCodec)XZ.STREAM_CODEC.apply(ByteBufCodecs.collection(HashSet::new)), RequestChunkChangePacket::chunks, (StreamCodec)ByteBufCodecs.BOOL, RequestChunkChangePacket::tryAdminChanges, (StreamCodec)UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), RequestChunkChangePacket::teamId, RequestChunkChangePacket::new);

    public CustomPacketPayload.Type<RequestChunkChangePacket> type() {
        return TYPE;
    }

    public static void handle(RequestChunkChangePacket message, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        CommandSourceStack source = player.createCommandSourceStack();
        ChunkTeamDataImpl chunkTeamData = null;
        if (message.teamId().isPresent()) {
            Optional team = FTBTeamsAPI.api().getManager().getTeamByID(message.teamId().get());
            if (team.isEmpty()) {
                player.sendSystemMessage((Component)Component.translatable((String)"ftbteams.team_not_found", (Object[])new Object[]{message.teamId, ChatFormatting.RED}));
                return;
            }
            chunkTeamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)team.get());
        }
        if (chunkTeamData == null) {
            chunkTeamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(player);
        }
        ChunkTeamDataImpl data = chunkTeamData;
        Function<XZ, ClaimResult> consumer = switch (message.action.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> pos -> data.claim(source, pos.dim(player.level()), false);
            case 1 -> pos -> data.unclaim(source, pos.dim(player.level()), false, message.tryAdminChanges);
            case 2 -> pos -> data.forceLoad(source, pos.dim(player.level()), false, message.tryAdminChanges);
            case 3 -> pos -> data.unForceLoad(source, pos.dim(player.level()), false, message.tryAdminChanges);
        };
        EnumMap<ClaimResult.StandardProblem, Integer> problems = new EnumMap<ClaimResult.StandardProblem, Integer>(ClaimResult.StandardProblem.class);
        int changed = 0;
        for (XZ pos2 : message.chunks) {
            ClaimResult r = consumer.apply(pos2);
            if (!r.isSuccess()) {
                FTBChunks.LOGGER.debug(String.format("%s tried to %s @ %s:%d:%d but got result %s", player.getScoreboardName(), message.action.name, player.level().dimension().location(), pos2.x(), pos2.z(), r));
                if (!(r instanceof ClaimResult.StandardProblem)) continue;
                ClaimResult.StandardProblem cr = (ClaimResult.StandardProblem)r;
                problems.put(cr, problems.getOrDefault(cr, 0) + 1);
                continue;
            }
            ++changed;
        }
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ChunkChangeResponsePacket(message.chunks.size(), changed, problems));
        SendGeneralDataPacket.send((ChunkTeamData)data, player);
        if (message.teamId.isPresent()) {
            SendGeneralDataPacket.send((ChunkTeamData)chunkTeamData, data.getTeam().getOnlineMembers());
        }
    }

    public static enum ChunkChangeOp {
        CLAIM("claim"),
        UNCLAIM("unclaim"),
        LOAD("load"),
        UNLOAD("unload");

        private final String name;

        private ChunkChangeOp(String name) {
            this.name = name;
        }

        public static ChunkChangeOp create(boolean isLeftMouse, boolean isShift) {
            return isShift ? (isLeftMouse ? LOAD : UNLOAD) : (isLeftMouse ? CLAIM : UNCLAIM);
        }
    }
}

