/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class RFCraftingRecipe {
    private final List<ItemStack> inv = new ArrayList<ItemStack>(9);
    private ItemStack result;
    private boolean recipePresent;
    private Optional<RecipeHolder<CraftingRecipe>> recipe;
    private boolean keepOne;
    public static final Codec<RFCraftingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("inv").forGetter(r -> r.inv), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(RFCraftingRecipe::getResult), (App)Codec.BOOL.fieldOf("keepOne").forGetter(RFCraftingRecipe::isKeepOne), (App)CraftMode.CODEC.fieldOf("craftMode").forGetter(RFCraftingRecipe::getCraftMode)).apply((Applicative)instance, RFCraftingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RFCraftingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, r -> r.inv, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, r -> r.result, (StreamCodec)ByteBufCodecs.BOOL, r -> r.keepOne, CraftMode.STREAM_CODEC, r -> r.craftMode, RFCraftingRecipe::new);
    private CraftMode craftMode;

    public RFCraftingRecipe() {
        for (int i = 0; i < 9; ++i) {
            this.inv.add(ItemStack.EMPTY);
        }
        this.result = ItemStack.EMPTY;
        this.recipePresent = false;
        this.recipe = Optional.empty();
        this.keepOne = false;
        this.craftMode = CraftMode.EXT;
    }

    public RFCraftingRecipe(List<ItemStack> inv, ItemStack result, boolean keepOne, CraftMode craftMode) {
        for (int i = 0; i < 9; ++i) {
            this.inv.add(ItemStack.EMPTY);
        }
        this.result = ItemStack.EMPTY;
        this.recipePresent = false;
        this.recipe = Optional.empty();
        this.keepOne = false;
        this.craftMode = CraftMode.EXT;
        this.inv.addAll(inv);
        this.result = result;
        this.keepOne = keepOne;
        this.craftMode = craftMode;
    }

    public static Optional<RecipeHolder<CraftingRecipe>> findRecipe(Level world, CraftingInput inv) {
        return world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)inv, world);
    }

    public void readFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        ListTag nbtTagList = tagCompound.getList("Items", 10);
        for (int i = 0; i < nbtTagList.size(); ++i) {
            CompoundTag tag = nbtTagList.getCompound(i);
            this.inv.set(i, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag));
        }
        CompoundTag resultCompound = tagCompound.getCompound("Result");
        this.result = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)resultCompound);
        this.keepOne = tagCompound.getBoolean("Keep");
        this.craftMode = CraftMode.values()[tagCompound.getByte("Int")];
        this.recipePresent = false;
    }

    public void writeToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inv.get(i);
            nbtTagList.add((Object)stack.saveOptional(provider));
        }
        tagCompound.put("Result", this.result.saveOptional(provider));
        tagCompound.put("Items", (Tag)nbtTagList);
        tagCompound.putBoolean("Keep", this.keepOne);
        tagCompound.putByte("Int", (byte)this.craftMode.ordinal());
    }

    public void setRecipe(ItemStack[] items, ItemStack result) {
        for (int i = 0; i < 9; ++i) {
            this.inv.set(i, items[i]);
        }
        this.result = result;
        this.recipePresent = false;
    }

    public List<ItemStack> getInventory() {
        return this.inv;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Optional<RecipeHolder<CraftingRecipe>> getCachedRecipe(Level world) {
        if (!this.recipePresent) {
            this.recipePresent = true;
            this.recipe = RFCraftingRecipe.findRecipe(world, CraftingInput.ofPositioned((int)3, (int)3, this.inv).input());
        }
        return this.recipe;
    }

    public boolean isKeepOne() {
        return this.keepOne;
    }

    public void setKeepOne(boolean keepOne) {
        this.keepOne = keepOne;
    }

    public CraftMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftMode craftMode) {
        this.craftMode = craftMode;
    }

    public static enum CraftMode implements StringRepresentable
    {
        EXT("Ext"),
        INT("Int"),
        EXTC("ExtC");

        public static final Codec<CraftMode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, CraftMode> STREAM_CODEC;
        private final String description;

        private CraftMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(CraftMode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(CraftMode.class);
        }
    }
}

