/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Cached;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.api.storage.IInventoryTracker;
import mcjty.rftoolsbase.api.storage.IModularStorage;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.InventoriesItemSource;
import mcjty.rftoolsstorage.craftinggrid.StorageCraftingTools;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageContainer;
import mcjty.rftoolsstorage.modules.modularstorage.data.ModularStorageData;
import mcjty.rftoolsstorage.modules.modularstorage.data.StorageModuleData;
import mcjty.rftoolsstorage.modules.modularstorage.items.StorageModuleItem;
import mcjty.rftoolsstorage.storage.GlobalStorageItemWrapper;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.StorageInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ModularStorageTileEntity
extends GenericTileEntity
implements IInventoryTracker,
CraftingGridProvider,
JEIRecipeAcceptor,
IModularStorage {
    private final Cached<Predicate<ItemStack>> filterCache = Cached.of(this::createFilterCache);
    private final ItemStackHandler cardHandler = this.createCardHandler();
    private final Lazy<IItemHandlerModifiable> items = Lazy.of(this::createGlobalHandler);
    @Cap(type=CapType.ITEMS)
    private static final Function<ModularStorageTileEntity, IItemHandlerModifiable> ITEM_CAP = tile -> (IItemHandlerModifiable)tile.items.get();
    @Cap(type=CapType.CONTAINER)
    private static final Function<ModularStorageTileEntity, MenuProvider> screenHandler = be -> new DefaultContainerProvider("Modular Storage").containerSupplier((windowId, player) -> new ModularStorageContainer((int)windowId, be.getBlockPos(), (ModularStorageTileEntity)be, (Player)player)).itemHandler(be.items).setupSync((GenericTileEntity)be);
    private GlobalStorageItemWrapper globalWrapper;
    private final CraftingGrid craftingGrid = new CraftingGrid();
    @GuiValue
    public static final Value<?, String> VALUE_SORTMODE = Value.create((String)"sortMode", (Type)Type.STRING, ModularStorageTileEntity::getSortMode, ModularStorageTileEntity::setSortMode);
    private String sortMode = "";
    @GuiValue
    public static final Value<ModularStorageTileEntity, String> VALUE_VIEWMODE = Value.create((String)"viewMode", (Type)Type.STRING, ModularStorageTileEntity::getViewMode, ModularStorageTileEntity::setViewMode);
    private String viewMode = "";
    @GuiValue
    public static final Value<?, Boolean> VALUE_GROUPMODE = Value.create((String)"groupMode", (Type)Type.BOOLEAN, ModularStorageTileEntity::isGroupMode, ModularStorageTileEntity::setGroupMode);
    private boolean groupMode = false;
    @GuiValue
    public static final Value<?, String> VALUE_FILTER = Value.create((String)"filter", (Type)Type.STRING, ModularStorageTileEntity::getFilter, ModularStorageTileEntity::setFilter);
    private String filter = "";
    public static final Key<String> PARAM_FILTER = new Key("filter", Type.STRING);
    public static final Key<String> PARAM_VIEWMODE = new Key("viewmode", Type.STRING);
    public static final Key<String> PARAM_SORTMODE = new Key("sortmode", Type.STRING);
    public static final Key<Boolean> PARAM_GROUPMODE = new Key("groupmode", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_LOCKED = new Key("locked", Type.BOOLEAN);
    @ServerCommand
    public static final Command<?> CMD_SETTINGS = Command.create((String)"storage.settings", (te, player, params) -> {
        te.setFilter((String)params.get(PARAM_FILTER));
        te.setViewMode((String)params.get(PARAM_VIEWMODE));
        te.setSortMode((String)params.get(PARAM_SORTMODE));
        te.setGroupMode((Boolean)params.get(PARAM_GROUPMODE));
        te.setLocked((Boolean)params.get(PARAM_LOCKED));
        te.setChanged();
    });
    @ServerCommand
    public static final Command<?> CMD_CLEARGRID = Command.create((String)"clearGrid", (te, player, params) -> te.clearGrid());
    @ServerCommand
    public static final Command<?> CMD_CYCLE = Command.create((String)"cycle", (te, player, params) -> te.cycle());
    @ServerCommand
    public static final Command<?> CMD_COMPACT = Command.create((String)"compact", (te, player, params) -> te.compact());

    public ModularStorageTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModularStorageModule.MODULAR_STORAGE.be().get(), pos, state);
    }

    public IItemHandlerModifiable getItems() {
        return (IItemHandlerModifiable)this.items.get();
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.setChanged();
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().setStackInSlot(i, stacks.get(i));
        }
        this.setChanged();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.setChanged();
    }

    @Override
    @Nonnull
    public List<Pair<ItemStack, Integer>> craft(Player player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IItemHandler)new InvWrapper((Container)player.getInventory()), 0);
        itemSource.add((IItemHandler)this.items.get(), 0);
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        return Collections.emptyList();
    }

    public boolean isGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(boolean groupMode) {
        this.groupMode = groupMode;
        this.setChanged();
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
        this.setChanged();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.setChanged();
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
        this.setChanged();
    }

    public int getRenderLevel() {
        return 0;
    }

    public void syncInventoryFromServer(String sortMode, String viewMode, boolean groupMode, String filter, boolean locked) {
        this.sortMode = sortMode;
        this.viewMode = viewMode;
        this.groupMode = groupMode;
        this.filter = filter;
        ModularStorageData data = (ModularStorageData)this.getData(ModularStorageModule.MODULAR_STORAGE_DATA);
        this.setData(ModularStorageModule.MODULAR_STORAGE_DATA, data.withLocked(locked));
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        for (int i = 0; i < this.cardHandler.getSlots(); ++i) {
            this.cardHandler.setStackInSlot(i, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tagCompound.getCompound("slot" + i)));
        }
        this.sortMode = tagCompound.getString("sortMode");
        this.viewMode = tagCompound.getString("viewMode");
        this.groupMode = tagCompound.getBoolean("groupMode");
        this.filter = tagCompound.getString("filter");
        this.craftingGrid.readFromNBT(tagCompound.getCompound("grid"), provider);
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        for (int i = 0; i < this.cardHandler.getSlots(); ++i) {
            tagCompound.put("slot" + i, this.cardHandler.getStackInSlot(i).saveOptional(provider));
        }
        tagCompound.putString("sortMode", this.sortMode);
        tagCompound.putString("viewMode", this.viewMode);
        tagCompound.putBoolean("groupMode", this.groupMode);
        tagCompound.putString("filter", this.filter);
        tagCompound.put("grid", (Tag)this.craftingGrid.writeToNBT(provider));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        ItemInventory items;
        super.applyImplicitComponents(input);
        ModularStorageData data = (ModularStorageData)input.get(ModularStorageModule.ITEM_MODULAR_STORAGE_DATA);
        if (data != null) {
            this.setData(ModularStorageModule.MODULAR_STORAGE_DATA, data);
        }
        if ((items = (ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY)) != null) {
            for (int i = 0; i < items.items().size(); ++i) {
                ItemStack stack = (ItemStack)items.items().get(i);
                this.cardHandler.setStackInSlot(i, stack);
            }
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ModularStorageModule.ITEM_MODULAR_STORAGE_DATA, (Object)((ModularStorageData)this.getData(ModularStorageModule.MODULAR_STORAGE_DATA)));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.cardHandler.getSlots(); ++i) {
            ItemStack stack = this.cardHandler.getStackInSlot(i);
            stacks.add(stack);
        }
        builder.set((Supplier)Registration.ITEM_INVENTORY, (Object)new ItemInventory(stacks));
    }

    private void clearGrid() {
        CraftingGridInventory inventory = this.craftingGrid.getCraftingGridInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.setChanged();
    }

    public void setLocked(boolean locked) {
        ItemStack card;
        ModularStorageData data = (ModularStorageData)this.getData(ModularStorageModule.MODULAR_STORAGE_DATA);
        this.setData(ModularStorageModule.MODULAR_STORAGE_DATA, data.withLocked(locked));
        if (!this.level.isClientSide && !(card = this.cardHandler.getStackInSlot(0)).isEmpty()) {
            StorageModuleData cardData = StorageModuleItem.getData(card);
            cardData = cardData.withInfoAmount(this.getNumStacks());
            StorageEntry storage = this.globalWrapper.getStorage();
            if (storage != null) {
                cardData = cardData.withCreationTime(storage.getCreationTime());
                cardData = cardData.withUpdateTime(storage.getUpdateTime());
            }
            card.set(ModularStorageModule.ITEM_STORAGE_MODULE_DATA, (Object)cardData);
        }
        this.setChanged();
    }

    public boolean isLocked() {
        ModularStorageData data = (ModularStorageData)this.getData(ModularStorageModule.MODULAR_STORAGE_DATA);
        return data.locked();
    }

    private void cycle() {
    }

    private void compact() {
        if (!this.isLocked()) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.globalWrapper.getSlots(); ++i) {
            ItemStack stack = this.globalWrapper.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
            this.globalWrapper.setStackInSlot(i, ItemStack.EMPTY);
        }
        for (ItemStack stack : stacks) {
            ItemHandlerHelper.insertItem((IItemHandler)this.globalWrapper, (ItemStack)stack, (boolean)false);
        }
        this.setChanged();
    }

    @Nonnull
    public StorageInfo getStorageInfo() {
        ItemStack storageCard = this.cardHandler.getStackInSlot(0);
        if (storageCard.isEmpty()) {
            return StorageInfo.EMPTY;
        }
        return StorageModuleItem.getStorageInfo(storageCard);
    }

    public int getVersion() {
        return this.getStorageInfo().version();
    }

    public int getMaxSize() {
        StorageInfo info = this.getStorageInfo();
        return info.size();
    }

    private Predicate<ItemStack> createFilterCache() {
        return FilterModuleItem.getCache((ItemStack)this.cardHandler.getStackInSlot(2));
    }

    @NotNull
    private ItemStackHandler createCardHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                if (slot == 0) {
                    if (ModularStorageTileEntity.this.globalWrapper != null) {
                        StorageInfo info = ModularStorageTileEntity.this.getStorageInfo();
                        ModularStorageTileEntity.this.globalWrapper.setInfo(info);
                    }
                } else if (slot == 2) {
                    ModularStorageTileEntity.this.filterCache.clear();
                }
                ModularStorageTileEntity.this.setChanged();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (ModularStorageTileEntity.this.isLocked()) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (ModularStorageTileEntity.this.isLocked()) {
                    return ItemStack.EMPTY;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    @Nonnull
    private IItemHandlerModifiable createGlobalHandler() {
        StorageInfo info = this.getStorageInfo();
        if (this.globalWrapper == null) {
            this.globalWrapper = new GlobalStorageItemWrapper(info, this.level.isClientSide){

                @Override
                public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                    boolean rc = super.isItemValid(slot, stack);
                    if (!rc) {
                        return false;
                    }
                    if (!ModularStorageTileEntity.this.cardHandler.getStackInSlot(2).isEmpty() && ModularStorageTileEntity.this.filterCache.get() != null) {
                        return ((Predicate)ModularStorageTileEntity.this.filterCache.get()).test(stack);
                    }
                    return true;
                }

                @Override
                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    if (!ModularStorageTileEntity.this.isLocked()) {
                        return stack;
                    }
                    return super.insertItem(slot, stack, simulate);
                }

                @Override
                @Nonnull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (!ModularStorageTileEntity.this.isLocked()) {
                        return ItemStack.EMPTY;
                    }
                    return super.extractItem(slot, amount, simulate);
                }
            };
            if (!this.level.isClientSide) {
                this.globalWrapper.setListener((version, slot) -> {
                    ItemStack storageSlot = this.cardHandler.getStackInSlot(0);
                    if (storageSlot.getItem() instanceof StorageModuleItem) {
                        StorageModuleData data = StorageModuleItem.getData(storageSlot);
                        data = data.withVersion(version);
                        storageSlot.set(ModularStorageModule.ITEM_STORAGE_MODULE_DATA, (Object)data);
                    }
                    this.markDirtyQuick();
                });
            }
        } else {
            this.globalWrapper.setInfo(info);
        }
        return this.globalWrapper;
    }

    public IItemHandler getCardHandler() {
        return this.cardHandler;
    }

    public int getNumStacks() {
        int cnt = 0;
        if (this.globalWrapper == null) {
            this.createGlobalHandler();
        }
        for (int i = 0; i < this.globalWrapper.getSlots(); ++i) {
            if (this.globalWrapper.getStackInSlot(i).isEmpty()) continue;
            ++cnt;
        }
        return cnt;
    }
}

