/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.ItemStackTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.TagTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlScreenModule;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record DumpScreenModule(GlobalPos pos, boolean active, List<ItemStack> stacks, boolean matchingTag, String line, int color) implements IScreenModule<DumpScreenModule, IModuleData>
{
    public static final int COLS = 7;
    public static final int ROWS = 4;
    public static final DumpScreenModule DEFAULT = new DumpScreenModule(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID), false, Collections.nCopies(28, ItemStack.EMPTY), false, "", 0xFFFFFF);
    public static final Codec<DumpScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("pos").forGetter(DumpScreenModule::pos), (App)Codec.BOOL.fieldOf("active").forGetter(DumpScreenModule::active), (App)ItemStack.CODEC.listOf().fieldOf("stacks").forGetter(DumpScreenModule::stacks), (App)Codec.BOOL.fieldOf("matchingTag").forGetter(DumpScreenModule::matchingTag), (App)Codec.STRING.fieldOf("line").forGetter(DumpScreenModule::line), (App)Codec.INT.fieldOf("color").forGetter(DumpScreenModule::color)).apply((Applicative)instance, DumpScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DumpScreenModule> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, DumpScreenModule::pos, (StreamCodec)ByteBufCodecs.BOOL, DumpScreenModule::active, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), DumpScreenModule::stacks, (StreamCodec)ByteBufCodecs.BOOL, DumpScreenModule::matchingTag, (StreamCodec)ByteBufCodecs.STRING_UTF8, DumpScreenModule::line, (StreamCodec)ByteBufCodecs.INT, DumpScreenModule::color, DumpScreenModule::new);

    public IModuleDataBoolean getData(IScreenDataHelper helper, Level worldObj, long millis) {
        return null;
    }

    public DumpScreenModule withActive(boolean active) {
        return new DumpScreenModule(this.pos, active, this.stacks, this.matchingTag, this.line, this.color);
    }

    public DumpScreenModule withLine(String line) {
        return new DumpScreenModule(this.pos, this.active, this.stacks, this.matchingTag, line, this.color);
    }

    public DumpScreenModule withColor(int color) {
        return new DumpScreenModule(this.pos, this.active, this.stacks, this.matchingTag, this.line, color);
    }

    public DumpScreenModule withMatchingTag(boolean matchingTag) {
        return new DumpScreenModule(this.pos, this.active, this.stacks, matchingTag, this.line, this.color);
    }

    public DumpScreenModule withStack(int index, ItemStack stack) {
        ArrayList<ItemStack> newstacks = new ArrayList<ItemStack>(this.stacks);
        newstacks.set(index, stack);
        return new DumpScreenModule(this.pos, this.active, newstacks, this.matchingTag, this.line, this.color);
    }

    public DumpScreenModule validate(Level world, BlockPos p, boolean isPlus) {
        if (isPlus) {
            return this.withActive(true);
        }
        if (LevelTools.isLoaded((Level)world, (BlockPos)this.pos.pos()) && Objects.equals(this.pos.dimension(), world.dimension())) {
            int dx = Math.abs(this.pos.pos().getX() - p.getX());
            int dy = Math.abs(this.pos.pos().getY() - p.getY());
            int dz = Math.abs(this.pos.pos().getZ() - p.getZ());
            if (dx <= 64 && dy <= 64 && dz <= 64) {
                return this.withActive(true);
            }
        }
        return this.withActive(false);
    }

    private boolean isShown(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (ItemStack s : this.stacks) {
            if (this.isItemEqual(stack, s)) {
                return true;
            }
            if (!this.matchingTag || !ItemStackTools.hasCommonTag((Collection)TagTools.getTags((Item)s.getItem()))) continue;
            return true;
        }
        return false;
    }

    public boolean isItemEqual(ItemStack thisItem, ItemStack other) {
        if (other.isEmpty()) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)thisItem, (ItemStack)other);
    }

    public ItemStack mouseClick(ItemStack moduleStack, Level world, int x, int y, boolean clicked, Player player) {
        if (!clicked || player == null) {
            return ItemStack.EMPTY;
        }
        if (BlockPosTools.INVALID.equals((Object)this.pos.pos())) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Module is not linked to storage scanner!")), false);
            return ItemStack.EMPTY;
        }
        IStorageScanner scannerTileEntity = StorageControlScreenModule.getStorageScanner(world, (ResourceKey<Level>)this.pos.dimension(), this.pos.pos());
        if (scannerTileEntity == null) {
            return ItemStack.EMPTY;
        }
        int xoffset = 5;
        if (x >= xoffset) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                if (!this.isShown(player.getInventory().getItem(i))) continue;
                ItemStack stack = scannerTileEntity.injectStackFromScreen(player.getInventory().getItem(i), player);
                player.getInventory().setItem(i, stack);
            }
            player.containerMenu.broadcastChanges();
        }
        return ItemStack.EMPTY;
    }

    public int getRfPerTick() {
        return (Integer)StorageScannerConfiguration.DUMP_RFPERTICK.get();
    }
}

