/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.Optional;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketServerCommandTyped(BlockPos pos, ResourceKey<Level> dimensionId, String command, TypedMap params) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mcjtylib", (String)"servercommandtyped");
    public static final CustomPacketPayload.Type<PacketServerCommandTyped> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketServerCommandTyped> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketServerCommandTyped::pos, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION).apply(ByteBufCodecs::optional), s -> Optional.ofNullable(s.dimensionId), (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketServerCommandTyped::command, TypedMap.STREAM_CODEC, PacketServerCommandTyped::params, PacketServerCommandTyped::new);

    private PacketServerCommandTyped(BlockPos pos, Optional<ResourceKey<Level>> dimensionId, String command, TypedMap params) {
        this(pos, (ResourceKey<Level>)((ResourceKey)dimensionId.orElse(null)), command, params);
    }

    public static PacketServerCommandTyped create(BlockPos blockPos, ResourceKey<Level> dimension, String command, TypedMap params) {
        return new PacketServerCommandTyped(blockPos, dimension, command, params);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            Object world = this.dimensionId == null ? player.getCommandSenderWorld() : LevelTools.getLevel(player.level(), this.dimensionId);
            if (world == null) {
                return;
            }
            if (world.hasChunkAt(this.pos)) {
                GenericTileEntity generic;
                BlockEntity patt0$temp = world.getBlockEntity(this.pos);
                if (patt0$temp instanceof GenericTileEntity && (generic = (GenericTileEntity)patt0$temp).executeServerCommand(this.command, player, this.params)) {
                    return;
                }
                Logging.log("Command " + this.command + " was not handled!");
            }
        });
    }
}

