/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block_network.element;

import com.hrznstudio.titanium.block_network.Network;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NetworkElement {
    protected final Level level;
    protected final BlockPos pos;
    private final Logger logger = LogManager.getLogger(this.getClass());
    protected Network network;

    public NetworkElement(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    public void update() {
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void joinNetwork(Network network) {
        this.network = network;
        this.logger.debug(String.valueOf(this.pos) + " joined network " + network.getId());
        this.sendBlockUpdate();
    }

    public void leaveNetwork() {
        this.logger.debug(String.valueOf(this.pos) + " left network " + this.network.getId());
        this.network = null;
        this.sendBlockUpdate();
    }

    public void sendBlockUpdate() {
        BlockState state = this.level.getBlockState(this.pos);
        this.level.sendBlockUpdated(this.pos, state, state, 3);
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.putLong("pos", this.pos.asLong());
        return tag;
    }

    public abstract ResourceLocation getId();

    public abstract ResourceLocation getNetworkType();

    public abstract boolean canConnectFrom(Direction var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkElement pipe = (NetworkElement)o;
        return this.level.equals(pipe.level) && this.pos.equals((Object)pipe.pos);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.pos);
    }
}

