/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.fluid;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.FacingHandlerScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.component.sideness.SidedComponentManager;
import com.hrznstudio.titanium.util.FacingUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class SidedFluidTankComponent<T extends IComponentHarness>
extends FluidTankComponent<T>
implements IFacingComponent,
IScreenAddonProvider {
    private int color = DyeColor.WHITE.getFireworkColor();
    private int facingHandlerX = 8;
    private int facingHandlerY = 84;
    private final Map<FacingUtil.Sideness, IFacingComponent.FaceMode> facingModes = new EnumMap<FacingUtil.Sideness, IFacingComponent.FaceMode>(FacingUtil.Sideness.class);
    private int pos;
    private boolean hasFacingAddon;
    private IFacingComponent.FaceMode[] validFaceModes;

    public SidedFluidTankComponent(String name, int amount, int posX, int posY, int pos) {
        super(name, amount, posX, posY);
        this.pos = pos;
        for (FacingUtil.Sideness facing : FacingUtil.Sideness.values()) {
            this.facingModes.put(facing, IFacingComponent.FaceMode.ENABLED);
        }
        this.hasFacingAddon = true;
        this.validFaceModes = IFacingComponent.FaceMode.values();
    }

    public SidedFluidTankComponent<T> disableFacingAddon() {
        this.hasFacingAddon = false;
        return this;
    }

    @Override
    public Map<FacingUtil.Sideness, IFacingComponent.FaceMode> getFacingModes() {
        return this.facingModes;
    }

    @Override
    public int getColor() {
        return new Color(this.color).getRGB();
    }

    public SidedFluidTankComponent<T> setColor(int color) {
        this.color = color;
        return this;
    }

    public SidedFluidTankComponent<T> setColor(DyeColor color) {
        this.color = color.getFireworkColor();
        return this;
    }

    @Override
    public Rectangle getRectangle(IAsset asset) {
        return new Rectangle(this.getPosX() - 2, this.getPosY() - 2, (int)asset.getArea().getWidth() + 3, (int)asset.getArea().getHeight() + 3);
    }

    @Override
    public int getFacingHandlerX() {
        return this.facingHandlerX;
    }

    @Override
    public int getFacingHandlerY() {
        return this.facingHandlerY;
    }

    private boolean workSides(Level level, BlockPos pos, Direction blockFacing, int workAmount, IFacingComponent.FaceMode mode) {
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            Direction real;
            IFluidHandler cap;
            if (this.facingModes.get((Object)sideness) != mode || (cap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(real = FacingUtil.getFacingFromSide(blockFacing, sideness)), (Object)real.getOpposite())) == null || !this.transfer((IFluidHandler)(mode == IFacingComponent.FaceMode.PUSH ? this : cap), (IFluidHandler)(mode == IFacingComponent.FaceMode.PUSH ? cap : this), workAmount)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean work(Level world, BlockPos pos, Direction blockFacing, int workAmount) {
        if (this.workSides(world, pos, blockFacing, workAmount, IFacingComponent.FaceMode.PUSH)) {
            return true;
        }
        return this.workSides(world, pos, blockFacing, workAmount, IFacingComponent.FaceMode.PULL);
    }

    @Override
    public SidedFluidTankComponent<T> setFacingHandlerPos(int x, int y) {
        this.facingHandlerX = x;
        this.facingHandlerY = y;
        return this;
    }

    @Override
    public IFacingComponent.FaceMode[] getValidFacingModes() {
        return this.validFaceModes;
    }

    public SidedFluidTankComponent<T> setValidFaceModes(IFacingComponent.FaceMode ... validFaceModes) {
        this.validFaceModes = validFaceModes;
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.facingModes.put(value, validFaceModes[0]);
        }
        return this;
    }

    private boolean transfer(IFluidHandler from, IFluidHandler to, int workAmount) {
        for (int tank = 0; tank < from.getTanks(); ++tank) {
            FluidStack fluidStack = from.getFluidInTank(tank);
            fluidStack = fluidStack.copyWithAmount(Math.min(workAmount * 100, fluidStack.getAmount()));
            if ((fluidStack = from.drain(fluidStack, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) continue;
            fluidStack = fluidStack.copyWithAmount(to.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE));
            if ((fluidStack = from.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        List<IFactory<? extends IScreenAddon>> addons = super.getScreenAddons();
        if (this.hasFacingAddon) {
            addons.add(() -> new FacingHandlerScreenAddon(SidedComponentManager.ofRight(this.getFacingHandlerX(), this.getFacingHandlerY(), this.pos, AssetTypes.BUTTON_SIDENESS_MANAGER, 4), this, this.getTankType().getAssetType(), this.getComponentHarness() instanceof ActiveTile ? ((ActiveTile)this.getComponentHarness()).getFacingDirection() : Direction.NORTH));
        }
        return addons;
    }

    public FluidTank readFromNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("FacingModes")) {
            CompoundTag compound = nbt.getCompound("FacingModes");
            for (String face : compound.getAllKeys()) {
                this.facingModes.put(FacingUtil.Sideness.valueOf(face), IFacingComponent.FaceMode.valueOf(compound.getString(face)));
            }
        }
        return super.readFromNBT(provider, nbt);
    }

    public CompoundTag writeToNBT(HolderLookup.Provider provider, CompoundTag comp) {
        CompoundTag nbt = super.writeToNBT(provider, comp);
        CompoundTag compound = new CompoundTag();
        for (FacingUtil.Sideness facing : this.facingModes.keySet()) {
            compound.putString(facing.name(), this.facingModes.get((Object)facing).name());
        }
        nbt.put("FacingModes", (Tag)compound);
        return nbt;
    }
}

