/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyGroup;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.lib.util.Color;

public enum GearPropertyGroups implements GearPropertyGroup
{
    SPECIAL(Color.GOLDENROD),
    GENERAL(Color.STEELBLUE),
    HARVEST(Color.SEAGREEN),
    ATTACK(Color.SANDYBROWN),
    PROJECTILE(Color.SKYBLUE),
    ARMOR(Color.VIOLET);

    private final Color color;

    private GearPropertyGroups(Color color) {
        this.color = color;
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Set<GearProperty<?, ?>> getProperties() {
        LinkedHashSet set = new LinkedHashSet();
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            if (property.getGroup() != this) continue;
            set.add(property);
        }
        return set;
    }

    public static Set<GearProperty<?, ?>> getSortedRelevantProperties(Set<GearPropertyGroup> relevantPropertyGroups) {
        LinkedHashSet result = new LinkedHashSet();
        for (GearPropertyGroups group : GearPropertyGroups.values()) {
            if (!relevantPropertyGroups.contains(group)) continue;
            result.addAll(group.getProperties());
        }
        return result;
    }
}

