/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.TooltipFlag;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.util.TextUtil;

public record TraitInstance(DataResource<Trait> trait, int level, ImmutableList<ITraitCondition> conditions) {
    public static final Codec<TraitInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DataResource.TRAIT_CODEC.fieldOf("trait").forGetter(t -> t.trait), (App)ExtraCodecs.POSITIVE_INT.fieldOf("level").forGetter(t -> t.level), (App)Codec.list(ITraitCondition.DISPATCH_CODEC).optionalFieldOf("conditions").forGetter(t -> Optional.of(new ArrayList<ITraitCondition>((Collection<ITraitCondition>)t.conditions)))).apply((Applicative)instance, (id, level, conditions) -> new TraitInstance((DataResource<Trait>)id, (int)level, conditions.orElse(Collections.emptyList()))));
    public static final StreamCodec<RegistryFriendlyByteBuf, TraitInstance> STREAM_CODEC = StreamCodec.composite(DataResource.TRAIT_STREAM_CODEC, t -> t.trait, (StreamCodec)ByteBufCodecs.VAR_INT, t -> t.level, (StreamCodec)ITraitCondition.STREAM_CODEC.apply(ByteBufCodecs.list()), t -> new ArrayList<ITraitCondition>((Collection<ITraitCondition>)t.conditions), TraitInstance::new);

    private TraitInstance(Trait trait, int level, ITraitCondition ... conditions) {
        this(DataResource.trait(SgRegistries.TRAIT.getKey(trait)), level, conditions);
    }

    private TraitInstance(DataResource<Trait> trait, int level, ITraitCondition ... conditions) {
        this(trait, level, Arrays.asList(conditions));
    }

    private TraitInstance(DataResource<Trait> trait, int level, List<ITraitCondition> conditions) {
        this(trait, level, TraitInstance.createFilteredConditionsList(trait, conditions));
    }

    private static ImmutableList<ITraitCondition> createFilteredConditionsList(DataResource<Trait> trait, List<ITraitCondition> conditions) {
        LinkedHashSet<ITraitCondition> set = new LinkedHashSet<ITraitCondition>();
        if (trait.isPresent()) {
            set.addAll(trait.get().getConditions());
        }
        set.addAll(conditions);
        return ImmutableList.copyOf(set);
    }

    public static TraitInstance of(DataResource<Trait> trait, int level, ITraitCondition ... conditions) {
        return new TraitInstance(trait, level, conditions);
    }

    public static TraitInstance of(Trait trait, int level, ITraitCondition ... conditions) {
        return new TraitInstance(trait, level, conditions);
    }

    public boolean isValid() {
        return this.trait.isPresent() && this.level > 0;
    }

    public ResourceLocation getTraitId() {
        return this.trait.getId();
    }

    @Nonnull
    public Trait getTrait() {
        return this.trait.get();
    }

    public int getLevel() {
        return this.level;
    }

    public Collection<ITraitCondition> getConditions() {
        return this.conditions;
    }

    public MutableComponent getDisplayName() {
        return this.getDisplayName(GearProperty.FormatContext.ANY);
    }

    public MutableComponent getDisplayName(GearProperty.FormatContext formatContext) {
        MutableComponent text = this.trait.get().getDisplayName(this.level).copy();
        if (formatContext != GearProperty.FormatContext.GEAR && !this.conditions.isEmpty()) {
            text.append("*");
        }
        return text;
    }

    public MutableComponent getDescription() {
        return this.trait.get().getDescription(this.level);
    }

    public void addInformation(List<Component> tooltip, TooltipFlag flag) {
        if (!this.trait.get().showInTooltip(flag)) {
            return;
        }
        MutableComponent displayName = this.getDisplayName().withStyle(ChatFormatting.ITALIC);
        tooltip.add((Component)(this.trait.get().isHidden() ? TextUtil.withColor(displayName, ChatFormatting.DARK_GRAY) : displayName));
        if (KeyTracker.isAltDown()) {
            MutableComponent description = TextUtil.withColor(this.trait.get().getDescription(this.level), ChatFormatting.DARK_GRAY);
            tooltip.add((Component)Component.literal((String)"    ").append((Component)description));
        }
    }

    public boolean conditionsMatch(PartGearKey key, List<? extends GearComponentInstance<?>> components) {
        Trait trait = this.getTrait();
        for (ITraitCondition condition : this.getConditions()) {
            if (condition.matches(trait, key, components)) continue;
            return false;
        }
        return true;
    }

    public MutableComponent getConditionsText() {
        return this.getConditions().stream().map(ITraitCondition::getDisplayText).reduce((t1, t2) -> t1.append((Component)TextUtil.translate("trait.condition", "and")).append((Component)t2)).orElseGet(() -> Component.literal((String)""));
    }

    @Override
    public String toString() {
        return this.getDisplayName().getString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraitInstance)) {
            return false;
        }
        TraitInstance other = (TraitInstance)obj;
        if (!this.trait.equals(other.trait) || this.level != other.level || this.conditions.size() != other.conditions.size()) {
            return false;
        }
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (((ITraitCondition)this.conditions.get(i)).equals(other.conditions.get(i))) continue;
            return false;
        }
        return true;
    }
}

