/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;

public final class SynergyTraitEffect
extends TraitEffect {
    public static final MapCodec<SynergyTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("multiplier").forGetter(e -> Float.valueOf(e.multi)), (App)Codec.FLOAT.optionalFieldOf("range_min", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.rangeMin)), (App)Codec.FLOAT.optionalFieldOf("range_max", (Object)Float.valueOf(Float.MAX_VALUE)).forGetter(e -> Float.valueOf(e.rangeMax))).apply((Applicative)instance, SynergyTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SynergyTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.multi), (StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.rangeMin), (StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.rangeMax), SynergyTraitEffect::new);
    private final float multi;
    private final float rangeMin;
    private final float rangeMax;

    public SynergyTraitEffect(float multi) {
        this(multi, 0.0f, Float.MAX_VALUE);
    }

    public SynergyTraitEffect(float multi, float rangeMin, float rangeMax) {
        this.multi = multi;
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.SYNERGY_MULTIPLIER.get();
    }

    @Override
    public double onCalculateSynergy(double synergy, int traitLevel) {
        if (synergy > (double)this.rangeMin && synergy < (double)this.rangeMax) {
            return synergy + (double)((float)traitLevel * this.multi);
        }
        return synergy;
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("  - Please read [this page](https://github.com/SilentChaos512/Silent-Gear/wiki/Synergy) for more information on synergy");
        String multiStr = "  - " + (String)(this.multi > 0.0f ? "+" + this.multi : String.valueOf(this.multi));
        String str = this.rangeMax < Float.MAX_VALUE ? multiStr + " synergy per level if between " + SynergyTraitEffect.formatPercent(this.rangeMin) + " and " + SynergyTraitEffect.formatPercent(this.rangeMax) : multiStr + " synergy per level if greater than " + SynergyTraitEffect.formatPercent(this.rangeMin);
        ret.add(str);
        return ret;
    }

    private static String formatPercent(float value) {
        return (int)(value * 100.0f) + "%";
    }
}

