/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;

public final class GearGenerator {
    private GearGenerator() {
        throw new IllegalAccessError("Utility class");
    }

    public static Optional<PartInstance> getRandomPart(GearType gearType, PartType partType) {
        return partType.getCompoundPartItem(gearType).map(GearGenerator::createRandom);
    }

    private static PartInstance createRandom(CompoundPartItem item) {
        Material material = SgRegistries.MATERIAL.getRandomObtainable(SilentGear.RANDOM_SOURCE).orElse((Material)SgRegistries.MATERIAL.get(Const.Materials.EXAMPLE.getId()));
        ItemStack stack = item.create(MaterialInstance.of(Objects.requireNonNull(material)));
        return PartInstance.from(stack);
    }

    public static ItemStack create(GearItem item) {
        return GearGenerator.randomizeParts(new ItemStack((ItemLike)item));
    }

    public static ItemStack randomizeParts(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof GearItem)) {
            throw new RuntimeException("Called GearGenerator.randomizeParts on non-gear");
        }
        GearItem item2 = (GearItem)item;
        GearType gearType = item2.getGearType();
        PartList parts = PartList.of(new PartInstance[0]);
        for (PartType partType : item2.getRequiredParts()) {
            GearGenerator.getRandomPart(gearType, partType).ifPresent(parts::add);
        }
        if (parts.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = stack.copy();
        GearData.writeConstructionParts(result, parts);
        if (item2 instanceof GearTool && SilentGear.RANDOM.nextFloat() < 0.3f) {
            GearGenerator.getRandomPart(gearType, (PartType)PartTypes.TIP.get()).ifPresent(part -> GearData.addUpgradePart(result, part));
        }
        GearData.recalculateGearData(result, null);
        parts.forEach(p -> p.onAddToGear(result));
        return result;
    }
}

