/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.api.item;

import com.alexthw.sauce.api.item.IElementalArmor;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.setup.registry.MaterialRegistry;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import lyrellion.ars_elemancy.common.items.armor.AAMaterials;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public interface IElemancyArmor
extends IElementalArmor {
    public static Holder<ArmorMaterial> schoolToMaterial(SpellSchool element) {
        return switch (element.getId()) {
            case "tempest" -> AAMaterials.TEMPEST;
            case "silt" -> AAMaterials.SILT;
            case "mire" -> AAMaterials.MIRE;
            case "vapor" -> AAMaterials.VAPOR;
            case "lava" -> AAMaterials.LAVA;
            case "cinder" -> AAMaterials.CINDER;
            case "elemental" -> AAMaterials.ELEMANCER;
            default -> MaterialRegistry.MEDIUM;
        };
    }

    default public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        if (this.getSchool().isPartOfSchool(spellPart)) {
            builder.addAmplification(0.5);
        }
        return builder;
    }

    default public double getDiscount(List<AbstractSpellPart> recipe) {
        double sum = 0.0;
        for (AbstractSpellPart part : recipe) {
            if (!this.getSchool().isPartOfSchool(part)) continue;
            sum += 0.2 * (double)part.getCastingCost();
        }
        return sum;
    }

    public SpellSchool getSchool();

    public String getTier();

    default public boolean doAbsorb(DamageSource damageSource) {
        if (damageResistances.containsKey(this.getSchool()) && damageSource.is((TagKey)damageResistances.get(this.getSchool()))) {
            return true;
        }
        for (SpellSchool school : this.getSchool().getSubSchools()) {
            if (!damageResistances.containsKey(school) || !damageSource.is((TagKey)damageResistances.get(school))) continue;
            return true;
        }
        return false;
    }

    default public boolean fillAbsorptions(DamageSource damageSource, HashMap<SpellSchool, Integer> bonusMap) {
        boolean changed = false;
        SpellSchool mainSchool = this.getSchool();
        if (damageResistances.containsKey(mainSchool) && damageSource.is((TagKey)damageResistances.get(mainSchool))) {
            bonusMap.put(mainSchool, bonusMap.getOrDefault(mainSchool, 0) + 1);
            changed = true;
        }
        for (SpellSchool school : mainSchool.getSubSchools()) {
            if (damageResistances.containsKey(school) && damageSource.is((TagKey)damageResistances.get(school))) {
                bonusMap.put(school, bonusMap.getOrDefault(school, 0) + 1);
            }
            changed = true;
        }
        return changed;
    }
}

