/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import me.lucko.spark.api.Spark;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.monitor.ping.PlayerPingProvider;
import me.lucko.spark.common.monitor.tick.TickStatistics;
import me.lucko.spark.common.platform.MetadataProvider;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.serverconfig.ServerConfigProvider;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.common.sampler.source.SourceMetadata;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.common.util.classfinder.ClassFinder;
import me.lucko.spark.common.util.classfinder.FallbackClassFinder;
import me.lucko.spark.common.util.classfinder.InstrumentationClassFinder;
import me.lucko.spark.common.util.log.Logger;

public interface SparkPlugin
extends Logger {
    public String getVersion();

    public Path getPluginDirectory();

    public String getCommandName();

    public Stream<? extends CommandSender> getCommandSenders();

    public void executeAsync(Runnable var1);

    default public void executeSync(Runnable task) {
        throw new UnsupportedOperationException();
    }

    default public ThreadDumper getDefaultThreadDumper() {
        return ThreadDumper.ALL;
    }

    default public TickHook createTickHook() {
        return null;
    }

    default public TickReporter createTickReporter() {
        return null;
    }

    default public TickStatistics createTickStatistics() {
        return null;
    }

    default public ClassSourceLookup createClassSourceLookup() {
        return ClassSourceLookup.NO_OP;
    }

    default public ClassFinder createClassFinder() {
        return ClassFinder.combining(new InstrumentationClassFinder(this), FallbackClassFinder.INSTANCE);
    }

    default public Collection<SourceMetadata> getKnownSources() {
        return Collections.emptyList();
    }

    default public PlayerPingProvider createPlayerPingProvider() {
        return null;
    }

    default public ServerConfigProvider createServerConfigProvider() {
        return null;
    }

    default public MetadataProvider createExtraMetadataProvider() {
        return null;
    }

    default public WorldInfoProvider createWorldInfoProvider() {
        return WorldInfoProvider.NO_OP;
    }

    public PlatformInfo getPlatformInfo();

    default public void registerApi(Spark api) {
    }
}

