/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.feet;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.octostudios.rarcompat.network.packets.PowerJumpPacket;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import top.theillusivec4.curios.api.SlotContext;

public class BunnyHoppersItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"hold").stat(StatData.builder((String)"duration").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)(value / 20.0), (int)2)).build()).research(ResearchData.builder().star(0, 3, 16).star(1, 8, 15).star(2, 7, 11).star(3, 9, 6).star(4, 11, 8).star(5, 14, 17).star(6, 16, 14).star(7, 17, 22).link(0, 1).link(1, 2).link(2, 3).link(2, 4).link(1, 5).link(5, 6).link(5, 7).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-5730187).borderBottom(-12109265).build()).beams(BeamsData.builder().startColor(-1127196).endColor(2958109).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"hold").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.PLAINS, LootEntries.FOREST}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LocalPlayer localPlayer;
        Level level;
        Player player;
        block10: {
            block9: {
                MobEffectInstance jumpBoost;
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player) || !this.canPlayerUseAbility(player = (Player)livingEntity, stack, "hold")) {
                    return;
                }
                if (player.onGround()) {
                    this.addTime(stack, -this.getTime(stack));
                }
                double statValue = this.getStatValue(stack, "hold", "duration");
                if (player.hasEffect(MobEffects.JUMP) && (jumpBoost = player.getEffect(MobEffects.JUMP)) != null) {
                    statValue += (double)((jumpBoost.getAmplifier() + 1) * 4);
                }
                if (!(level = player.getCommandSenderWorld()).isClientSide() || !(player instanceof LocalPlayer)) break block9;
                localPlayer = (LocalPlayer)player;
                if (!((double)this.getTime(stack) >= statValue) && !player.isFallFlying() && this.getToggled(stack)) break block10;
            }
            return;
        }
        if (!localPlayer.input.jumping) {
            this.setToggled(stack, false);
        } else {
            NetworkHandler.sendToServer((CustomPacketPayload)new PowerJumpPacket());
            player.setDeltaMovement(new Vec3(player.getDeltaMovement().x, 0.6, player.getDeltaMovement().z));
            RandomSource random = player.getRandom();
            for (int i = 0; i < 10; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * 0.5;
                double offsetY = (random.nextDouble() - 0.5) * 0.5;
                double offsetZ = (random.nextDouble() - 0.5) * 0.5;
                level.addParticle(ParticleUtils.constructSimpleSpark((Color)new Color(200 + random.nextInt(56), 200 + random.nextInt(56), 200 + random.nextInt(56)), (float)0.5f, (int)40, (float)0.9f), player.getX() + offsetX, player.getY() + 0.1 + offsetY, player.getZ() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void addTime(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)(this.getTime(stack) + val));
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setToggled(ItemStack stack, boolean val) {
        stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)val);
    }

    public boolean getToggled(ItemStack stack) {
        return (Boolean)stack.getOrDefault((Supplier)DataComponentRegistry.TOGGLED, (Object)false);
    }

    @EventBusSubscriber
    public static class BunnyHoppersEvent {
        @SubscribeEvent
        public static void onPlayerJumping(LivingEvent.LivingJumpEvent event) {
            BunnyHoppersItem relic;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.BUNNY_HOPPERS.value()));
            Item item = stack.getItem();
            if (!(item instanceof BunnyHoppersItem) || !(relic = (BunnyHoppersItem)item).canPlayerUseAbility(player, stack, "hold")) {
                return;
            }
            relic.setToggled(stack, true);
        }

        @SubscribeEvent
        public static void onPlayerFall(LivingFallEvent event) {
            BunnyHoppersItem relic;
            ItemStack stack;
            block5: {
                block4: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) {
                        return;
                    }
                    Player player = (Player)livingEntity;
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.BUNNY_HOPPERS.value()));
                    Item item = stack.getItem();
                    if (!(item instanceof BunnyHoppersItem)) break block4;
                    relic = (BunnyHoppersItem)item;
                    if (!player.getCommandSenderWorld().isClientSide()) break block5;
                }
                return;
            }
            event.setDistance(Math.max(event.getDistance() - (float)relic.getTime(stack) * 1.2f, 0.0f));
        }
    }
}

