/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.network.packets;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.charm.HeliumFlamingoItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class FlamingoSwimPacket
implements CustomPacketPayload {
    private final boolean toggled;
    public static final CustomPacketPayload.Type<FlamingoSwimPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"rarcompat", (String)"swim"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlamingoSwimPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, FlamingoSwimPacket::isToggled, FlamingoSwimPacket::new);

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.HELIUM_FLAMINGO.value()));
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof HeliumFlamingoItem)) {
                return;
            }
            HeliumFlamingoItem relic = (HeliumFlamingoItem)patt0$temp;
            if (this.toggled) {
                player.setSprinting(true);
                relic.setToggled(stack, true);
            } else {
                player.setSprinting(false);
                relic.setTime(stack, (int)relic.getStatValue(stack, "flying", "time") + 10);
                relic.setToggled(stack, false);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlamingoSwimPacket)) {
            return false;
        }
        FlamingoSwimPacket other = (FlamingoSwimPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isToggled() == other.isToggled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlamingoSwimPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isToggled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "FlamingoSwimPacket(toggled=" + this.isToggled() + ")";
    }

    public FlamingoSwimPacket(boolean toggled) {
        this.toggled = toggled;
    }
}

