/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.modules.crafter.CrafterModule;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterBaseTE;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterContainer;
import mcjty.rftoolsutility.modules.crafter.data.CraftingRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class GuiCrafter
extends GenericGuiContainer<CrafterBaseTE, CrafterContainer> {
    private EnergyBar energyBar;
    private WidgetList recipeList;
    private Button applyButton;
    private static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"rftoolsbase", (String)"textures/gui/guielements.png");

    public GuiCrafter(CrafterContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((BaseBlock)CrafterModule.CRAFTER1.block().get()).getManualEntry());
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(CrafterModule.CONTAINER_CRAFTER.get(), GuiCrafter::new);
    }

    public void init() {
        this.window = new Window((Screen)this, this.getBE(), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"gui/crafter.gui"));
        super.init();
        this.initializeFields();
        this.window.event("select", (source, params) -> this.selectRecipe());
    }

    private void initializeFields() {
        this.recipeList = (WidgetList)this.window.findChild("recipes");
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.applyButton = (Button)this.window.findChild("apply");
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        CrafterBaseTE tileEntity = (CrafterBaseTE)this.getBE();
        this.recipeList.selected(tileEntity.getSelected());
        ((ImageChoiceLabel)this.window.findChild("redstone")).setCurrentChoice(tileEntity.getRSMode().ordinal());
        this.populateList();
        this.updateEnergyBar(this.energyBar);
    }

    private void populateList() {
        this.recipeList.removeChildren();
        CrafterBaseTE tileEntity = (CrafterBaseTE)this.getBE();
        for (int i = 0; i < tileEntity.getSupportedRecipes(); ++i) {
            CraftingRecipe recipe = tileEntity.getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = Tools.getReadableName((ItemStack)craftingResult);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.isEmpty()) {
            readableName = "<no recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)Widgets.horizontal().children(new Widget[]{new BlockRender().renderItem((Object)craftingResult).tooltips(new String[]{"Double click to edit this recipe"}), ((Label)((Label)((Label)Widgets.label((String)readableName).color(color)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).dynamic(true)).tooltips(new String[]{"Double click to edit this recipe"})});
        this.recipeList.children(new Widget[]{panel});
    }

    private void selectRecipe() {
        int selected = this.recipeList.getSelected();
        this.setValue(CrafterBaseTE.SELECTED, selected);
    }

    private void updateButtons() {
        if (this.recipeList != null) {
            boolean selected = this.recipeList.getSelected() != -1;
            this.applyButton.enabled(selected);
        } else {
            this.applyButton.enabled(false);
        }
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        if (this.window == null) {
            return;
        }
        this.updateFields();
        this.updateButtons();
        this.drawWindow(graphics, partialTicks, mouseX, mouseY);
        this.drawGhostSlots(graphics);
    }

    private void drawGhostSlots(GuiGraphics graphics) {
        Lighting.setupFor3DItems();
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)this.leftPos, (float)this.topPos, 100.0f);
        CrafterBaseTE tileEntity = (CrafterBaseTE)this.getBE();
        List<ItemStack> ghostSlots = tileEntity.getGhostSlots();
        GlStateManager._enableDepthTest();
        GlStateManager._disableBlend();
        for (int i = 0; i < ghostSlots.size(); ++i) {
            int slotIdx;
            Slot slot;
            ItemStack stack = ghostSlots.get(i);
            if (stack.isEmpty() || (slot = ((CrafterContainer)this.menu).getSlot(slotIdx = i < 26 ? i + 10 : i + 36 - 26)).hasItem()) continue;
            RenderHelper.renderAndDecorateItem((GuiGraphics)graphics, (ItemStack)stack, (int)slot.x, (int)slot.y);
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconGuiElements);
            RenderHelper.drawTexturedModalRect((PoseStack)matrixStack, (int)slot.x, (int)slot.y, (int)224, (int)48, (int)16, (int)16);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        }
        matrixStack.popPose();
    }
}

