/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.client;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.SensorTileEntity;
import mcjty.rftoolsutility.modules.logic.tools.SensorType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class GuiSensor
extends GenericGuiContainer<SensorTileEntity, GenericContainer> {
    private ChoiceLabel typeLabel;

    public GuiSensor(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((LogicSlabBlock)LogicBlockModule.SENSOR.block().get()).getManualEntry());
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(LogicBlockModule.CONTAINER_SENSOR.get(), GuiSensor::new);
    }

    public void init() {
        this.window = new Window((Screen)this, this.getBE(), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"gui/sensor.gui"));
        super.init();
        this.initializeFields();
    }

    private void initializeFields() {
        this.typeLabel = (ChoiceLabel)this.window.findChild("type");
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        SensorType sensorType = (SensorType)NamedEnum.getEnumByName((String)this.typeLabel.getCurrentChoice(), (NamedEnum[])SensorType.values());
        if (sensorType != null) {
            this.window.setFlag("number", sensorType.isSupportsNumber());
            this.window.setFlag("group", sensorType.isSupportsGroup());
        }
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.updateFields();
        this.drawWindow(graphics, partialTicks, mouseX, mouseY);
    }
}

