/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.items;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.data.RedstoneInformationData;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationContainer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;

public class RedstoneInformationItem
extends Item
implements ITabletSupport,
ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create((String)"rftoolsbase:logic/redstone_information");
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"channels", stack -> {
        Set<Integer> channels = RedstoneInformationItem.getChannels(stack);
        List list = channels.stream().sorted().toList();
        Object s = "";
        String prefix = "";
        for (Integer channel : list) {
            s = (String)s + prefix + channel;
            prefix = ", ";
        }
        return s;
    })}));

    public RedstoneInformationItem() {
        super(RFToolsUtility.setup.defaultProperties().durability(1));
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public void appendHoverText(@Nonnull ItemStack itemStack, @Nullable Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flag);
    }

    public Item getInstalledTablet() {
        return (Item)LogicBlockModule.TABLET_REDSTONE.get();
    }

    public void openGui(@Nonnull Player player, @Nonnull ItemStack tabletItem, @Nonnull ItemStack containingItem) {
        player.openMenu(new MenuProvider(this){

            @Nonnull
            public Component getDisplayName() {
                return ComponentFactory.literal((String)"Redstone Module");
            }

            public AbstractContainerMenu createMenu(int id, @Nonnull Inventory playerInventory, @Nonnull Player player) {
                return new RedstoneInformationContainer(id, player.blockPosition(), player);
            }
        });
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            this.openGui(player, stack, stack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static Set<Integer> getChannels(ItemStack stack) {
        RedstoneInformationData data = (RedstoneInformationData)stack.getOrDefault(LogicBlockModule.ITEM_REDSTONE_INFORMATION_DATA, (Object)RedstoneInformationData.DEFAULT);
        return data.channels();
    }

    public static boolean addChannel(ItemStack stack, int channel) {
        RedstoneInformationData data = (RedstoneInformationData)stack.getOrDefault(LogicBlockModule.ITEM_REDSTONE_INFORMATION_DATA, (Object)RedstoneInformationData.DEFAULT);
        if (!data.hasChannel(channel)) {
            data = data.addChannel(channel);
            stack.set(LogicBlockModule.ITEM_REDSTONE_INFORMATION_DATA, (Object)data);
            return true;
        }
        return false;
    }

    public static void removeChannel(ItemStack stack, int channel) {
        RedstoneInformationData data = (RedstoneInformationData)stack.getOrDefault(LogicBlockModule.ITEM_REDSTONE_INFORMATION_DATA, (Object)RedstoneInformationData.DEFAULT);
        data = data.removeChannel(channel);
        stack.set(LogicBlockModule.ITEM_REDSTONE_INFORMATION_DATA, (Object)data);
    }
}

