/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.common.entity;

import com.google.common.collect.Maps;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.init.EntityInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;

public class DyenamicSheep
extends Sheep {
    private static final EntityDataAccessor<Byte> DATA_WOOL_ID = SynchedEntityData.defineId(DyenamicSheep.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final Map<DyenamicDyeColor, ItemLike> WOOL_BY_COLOR = (Map)Util.make((Object)Maps.newEnumMap(DyenamicDyeColor.class), map -> {
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            map.put(color, (ItemLike)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wool").get());
        }
    });
    private static final Map<DyeColor, ItemLike> VANILLA_WOOL_BY_COLOR = (Map)Util.make((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, Blocks.WHITE_WOOL);
        map.put(DyeColor.ORANGE, Blocks.ORANGE_WOOL);
        map.put(DyeColor.MAGENTA, Blocks.MAGENTA_WOOL);
        map.put(DyeColor.LIGHT_BLUE, Blocks.LIGHT_BLUE_WOOL);
        map.put(DyeColor.YELLOW, Blocks.YELLOW_WOOL);
        map.put(DyeColor.LIME, Blocks.LIME_WOOL);
        map.put(DyeColor.PINK, Blocks.PINK_WOOL);
        map.put(DyeColor.GRAY, Blocks.GRAY_WOOL);
        map.put(DyeColor.LIGHT_GRAY, Blocks.LIGHT_GRAY_WOOL);
        map.put(DyeColor.CYAN, Blocks.CYAN_WOOL);
        map.put(DyeColor.PURPLE, Blocks.PURPLE_WOOL);
        map.put(DyeColor.BLUE, Blocks.BLUE_WOOL);
        map.put(DyeColor.BROWN, Blocks.BROWN_WOOL);
        map.put(DyeColor.GREEN, Blocks.GREEN_WOOL);
        map.put(DyeColor.RED, Blocks.RED_WOOL);
        map.put(DyeColor.BLACK, Blocks.BLACK_WOOL);
    });

    public DyenamicSheep(EntityType<? extends DyenamicSheep> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0, Sheep.class));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_WOOL_ID, (Object)0);
    }

    public static void convertToVanilla(DyenamicSheep oldSheep, DyeColor color) {
        Level level = oldSheep.level();
        if (!level.isClientSide) {
            Sheep sheep = new Sheep(EntityType.SHEEP, level);
            sheep.load(sheep.saveWithoutId(new CompoundTag()));
            sheep.setColor(color);
            DyenamicSheep.convertSheep(oldSheep, sheep);
        }
    }

    public static void convertToDyenamics(Sheep oldSheep, DyenamicDyeColor color) {
        Level level = oldSheep.level();
        if (!level.isClientSide) {
            DyenamicSheep sheep = new DyenamicSheep((EntityType<? extends DyenamicSheep>)((EntityType)EntityInit.SHEEP.get()), level);
            sheep.load(sheep.saveWithoutId(new CompoundTag()));
            sheep.setColor(color);
            DyenamicSheep.convertSheep(oldSheep, sheep);
        }
    }

    private static void convertSheep(Sheep oldSheep, Sheep sheep) {
        Level level = oldSheep.level();
        if (!level.isClientSide) {
            sheep.setAge(oldSheep.getAge());
            sheep.copyPosition((Entity)oldSheep);
            level.addFreshEntity((Entity)sheep);
            oldSheep.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public ResourceKey<LootTable> getDefaultLootTable() {
        if (this.isSheared()) {
            return this.getType().getDefaultLootTable();
        }
        return EntityInit.SHEEP_LOOT.get(this.getDyenamicColor().getTranslationKey());
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem() instanceof DyeItem) {
            if (!this.level().isClientSide) {
                DyenamicSheep.convertToVanilla(this, ((DyeItem)itemstack.getItem()).getDyeColor());
                itemstack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (itemstack.getItem().equals(Items.SHEEP_SPAWN_EGG)) {
            if (!this.level().isClientSide) {
                DyenamicSheep sheep = new DyenamicSheep((EntityType<? extends DyenamicSheep>)((EntityType)EntityInit.SHEEP.get()), this.level());
                sheep.copyPosition((Entity)this);
                sheep.setBaby(true);
                sheep.setColor(this.getDyenamicColor());
                this.level().addFreshEntity((Entity)sheep);
                itemstack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public void shear(SoundSource category) {
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, category, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.random.nextInt(3);
        DyenamicDyeColor color = this.getDyenamicColor();
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = color.getId() > 15 ? this.spawnAtLocation(WOOL_BY_COLOR.get((Object)this.getDyenamicColor()), 1) : this.spawnAtLocation(VANILLA_WOOL_BY_COLOR.get(color.getVanillaColor()), 1);
            if (itementity == null) continue;
            itementity.setDeltaMovement(itementity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("Color", (byte)this.getDyenamicColor().getId());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setColor(DyenamicDyeColor.byId(compound.getByte("Color")));
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    public DyenamicDyeColor getDyenamicColor() {
        return DyenamicDyeColor.byId((Byte)this.entityData.get(DATA_WOOL_ID) & 0x7F);
    }

    public void setColor(DyeColor color) {
        byte b0 = (Byte)this.entityData.get(DATA_WOOL_ID);
        this.entityData.set(DATA_WOOL_ID, (Object)((byte)(b0 & 0xFFFFFF80 | color.getId() & 0xF)));
    }

    public void setColor(DyenamicDyeColor color) {
        byte b0 = (Byte)this.entityData.get(DATA_WOOL_ID);
        this.entityData.set(DATA_WOOL_ID, (Object)((byte)(b0 & 0xFFFFFF80 | color.getId() & 0x7F)));
    }

    public boolean isSheared() {
        return (Byte)this.entityData.get(DATA_WOOL_ID) < 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.entityData.get(DATA_WOOL_ID);
        if (sheared) {
            this.entityData.set(DATA_WOOL_ID, (Object)((byte)(b0 | 0xFFFFFF80)));
        } else {
            this.entityData.set(DATA_WOOL_ID, (Object)((byte)(b0 & 0x7F)));
        }
    }

    public Sheep getBreedOffspring(ServerLevel world, AgeableMob mate) {
        if (mate instanceof DyenamicSheep) {
            DyenamicSheep parent = (DyenamicSheep)mate;
            DyenamicSheep child = (DyenamicSheep)((EntityType)EntityInit.SHEEP.get()).create((Level)world);
            child.setColor(this.getDyeColorMixFromParents(this, parent));
            return child;
        }
        Sheep parent = (Sheep)mate;
        DyenamicDyeColor color = this.getDyeColorMixFromParents(this, parent);
        if (color.getId() < 16) {
            Sheep child = (Sheep)EntityType.SHEEP.create((Level)world);
            child.setColor(color.getAnalogue());
            return child;
        }
        DyenamicSheep child = (DyenamicSheep)((EntityType)EntityInit.SHEEP.get()).create((Level)world);
        child.setColor(color);
        return child;
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof Sheep) {
            return this.isInLove() && otherAnimal.isInLove();
        }
        if (otherAnimal.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.isInLove() && otherAnimal.isInLove();
    }

    protected DyenamicDyeColor getDyeColorMixFromParents(Sheep father, DyenamicSheep mother) {
        return this.level().random.nextBoolean() ? DyenamicDyeColor.byId(father.getColor().getId()) : mother.getDyenamicColor();
    }

    protected DyenamicDyeColor getDyeColorMixFromParents(DyenamicSheep mother, Sheep father) {
        return this.getDyeColorMixFromParents(father, mother);
    }

    protected DyenamicDyeColor getDyeColorMixFromParents(DyenamicSheep father, DyenamicSheep mother) {
        return this.level().random.nextBoolean() ? father.getDyenamicColor() : mother.getDyenamicColor();
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!this.level().isClientSide) {
            this.setSheared(true);
            int i = 1 + this.random.nextInt(3);
            DyenamicDyeColor color = this.getDyenamicColor();
            ItemStack stack = color.getId() > 15 ? new ItemStack(WOOL_BY_COLOR.get((Object)color)) : new ItemStack(VANILLA_WOOL_BY_COLOR.get(color.getVanillaColor()));
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(stack);
            }
            return items;
        }
        return Collections.emptyList();
    }

    public ItemStack getPickResult() {
        SpawnEggItem spawneggitem = SpawnEggItem.byId((EntityType)EntityType.SHEEP);
        return spawneggitem == null ? null : new ItemStack((ItemLike)spawneggitem);
    }
}

