/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.decorative;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesFalling;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlockMinecoloniesConstructionTape<B extends AbstractBlockMinecoloniesConstructionTape<B>>
extends AbstractBlockMinecoloniesFalling<B>
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected VoxelShape[] shapes = new VoxelShape[0];
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty CORNER = BooleanProperty.create((String)"corner");

    public AbstractBlockMinecoloniesConstructionTape(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[this.getIndex(state)];
    }

    private static int getMask(Direction facing) {
        return 1 << facing.get2DDataValue();
    }

    protected int getIndex(BlockState state) {
        int i = 0;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.NORTH);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.EAST);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.SOUTH);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.WEST);
        }
        return i;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected VoxelShape[] makeShapes(float nodeWidth, float limbWidth, float nodeHeight, float limbBase, float limbTop) {
        float nodeStart = 8.0f - nodeWidth;
        float nodeEnd = 8.0f + nodeWidth;
        float limbStart = 8.0f - limbWidth;
        float limbEnd = 8.0f + limbWidth;
        VoxelShape node = Block.box((double)nodeStart, (double)0.0, (double)nodeStart, (double)nodeEnd, (double)nodeHeight, (double)nodeEnd);
        VoxelShape north = Block.box((double)limbStart, (double)limbBase, (double)0.0, (double)limbEnd, (double)limbTop, (double)limbEnd);
        VoxelShape south = Block.box((double)limbStart, (double)limbBase, (double)limbStart, (double)limbEnd, (double)limbTop, (double)16.0);
        VoxelShape west = Block.box((double)0.0, (double)limbBase, (double)limbStart, (double)limbEnd, (double)limbTop, (double)limbEnd);
        VoxelShape east = Block.box((double)limbStart, (double)limbBase, (double)limbStart, (double)16.0, (double)limbTop, (double)limbEnd);
        VoxelShape cornernw = Shapes.or((VoxelShape)north, (VoxelShape)east);
        VoxelShape cornerse = Shapes.or((VoxelShape)south, (VoxelShape)west);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.empty(), south, west, cornerse, north, Shapes.or((VoxelShape)south, (VoxelShape)north), Shapes.or((VoxelShape)west, (VoxelShape)north), Shapes.or((VoxelShape)cornerse, (VoxelShape)north), east, Shapes.or((VoxelShape)south, (VoxelShape)east), Shapes.or((VoxelShape)west, (VoxelShape)east), Shapes.or((VoxelShape)cornerse, (VoxelShape)east), cornernw, Shapes.or((VoxelShape)south, (VoxelShape)cornernw), Shapes.or((VoxelShape)west, (VoxelShape)cornernw), Shapes.or((VoxelShape)cornerse, (VoxelShape)cornernw)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = Shapes.or((VoxelShape)node, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }
}

