/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICraftingBuildingModule
extends IBuildingModule {
    @Nullable
    public IJob<?> getCraftingJob();

    @Deprecated
    @NotNull
    public String getId();

    @NotNull
    public String getCustomRecipeKey();

    default public boolean canLearn(CraftingType type) {
        return this.getSupportedCraftingTypes().contains(type);
    }

    public Set<CraftingType> getSupportedCraftingTypes();

    public boolean isRecipeCompatible(@NotNull IGenericRecipe var1);

    @NotNull
    public OptionalPredicate<ItemStack> getIngredientValidator();

    public boolean canLearnManyRecipes();

    public boolean isVisible();

    public List<IToken<?>> getRecipes();

    @Nullable
    public IRecipeStorage getFirstRecipe(ItemStack var1);

    @Nullable
    public IRecipeStorage getFirstRecipe(Predicate<ItemStack> var1);

    public IRecipeStorage getFirstFulfillableRecipe(Predicate<ItemStack> var1, int var2, boolean var3);

    public boolean fullFillRecipe(IRecipeStorage var1);

    public ItemStack getCraftingTool(AbstractEntityCitizen var1);

    public float getCraftingLuck(AbstractEntityCitizen var1);

    public void updateWorkerAvailableForRecipes();

    public void replaceRecipe(IToken<?> var1, IToken<?> var2);

    public boolean canRecipeBeAdded(IToken<?> var1);

    public void addRecipeToList(IToken<?> var1, boolean var2);

    public void switchOrder(int var1, int var2, boolean var3);

    @NotNull
    public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level var1);

    @NotNull
    default public List<ResourceKey<LootTable>> getAdditionalLootTables() {
        return Collections.emptyList();
    }

    public boolean addRecipe(IToken<?> var1);

    public void removeRecipe(IToken<?> var1);

    public void checkForWorkerSpecificRecipes();

    public void clearRecipes();

    public void improveRecipe(IRecipeStorage var1, int var2, ICitizenData var3);

    @Deprecated
    @Nullable
    default public ResourceLocation getUid() {
        IJob<?> job = this.getCraftingJob();
        if (job == null) {
            return null;
        }
        JobEntry entry = job.getJobRegistryEntry();
        return ICraftingBuildingModule.getUid(entry, this.getId());
    }

    @NotNull
    public static ResourceLocation getUid(@NotNull JobEntry job, @NotNull String id) {
        ResourceLocation jobId = job.getKey();
        return new ResourceLocation(jobId.getNamespace(), jobId.getPath() + "/" + id);
    }

    public boolean holdsRecipe(IToken<?> var1);

    public void toggle(int var1);

    public boolean isDisabled(IToken<?> var1);
}

