/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.jobs;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.ai.ITickingStateAI;
import com.minecolonies.api.entity.ai.JobStatus;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public interface IJob<AI extends ITickingStateAI>
extends INBTSerializable<CompoundTag> {
    public JobEntry getJobRegistryEntry();

    public ResourceLocation getModel();

    public IColony getColony();

    public Set<IToken<?>> getAsyncRequests();

    public void createAI();

    public AI generateAI();

    public boolean hasCheckedForFoodToday();

    public void setCheckedForFood();

    public String getNameTagDescription();

    public void setNameTag(String var1);

    public void triggerDeathAchievement(DamageSource var1, AbstractEntityCitizen var2);

    public boolean onStackPickUp(@NotNull ItemStack var1);

    default public void onLevelUp() {
    }

    default public void initEntityValues(AbstractEntityCitizen citizen) {
        citizen.getCitizenData().setJobStatus(JobStatus.IDLE);
    }

    public ICitizenData getCitizen();

    public void onWakeUp();

    public boolean canAIBeInterrupted();

    public int getActionsDone();

    public void incrementActionsDone();

    public void incrementActionsDone(int var1);

    public void clearActionsDone();

    public AI getWorkerAI();

    public boolean isIdling();

    public void resetAI();

    public boolean allowsAvoidance();

    public double getDiseaseModifier();

    public void onRemoval();

    public boolean ignoresDamage(@NotNull DamageSource var1);

    public void markRequestSync(IToken<?> var1);

    public boolean pickupSuccess(@NotNull ItemStack var1);

    public void processOfflineTime(long var1);

    public void serializeToView(RegistryFriendlyByteBuf var1);

    default public int getInactivityLimit() {
        return -1;
    }

    default public int getIdleSeverity(boolean isDemand) {
        if (isDemand) {
            return 14;
        }
        return 7;
    }

    default public void triggerActivityChangeAction(boolean newState) {
    }

    public void setRegistryEntry(JobEntry var1);

    default public boolean isGuard() {
        return false;
    }

    public BlockPos getBuildingPos();

    public IBuilding getWorkBuilding();

    public IAssignsJob getWorkModule();

    public boolean assignTo(IAssignsJob var1);
}

