/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.configuration;

import com.ldtteam.common.config.AbstractConfiguration;
import com.minecolonies.api.colony.permissions.Explosions;
import java.util.List;
import java.util.function.Predicate;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfiguration
extends AbstractConfiguration {
    public final ModConfigSpec.IntValue initialCitizenAmount;
    public final ModConfigSpec.BooleanValue allowInfiniteSupplyChests;
    public final ModConfigSpec.BooleanValue allowInfiniteColonies;
    public final ModConfigSpec.BooleanValue allowOtherDimColonies;
    public final ModConfigSpec.IntValue maxCitizenPerColony;
    public final ModConfigSpec.BooleanValue enableInDevelopmentFeatures;
    public final ModConfigSpec.BooleanValue alwaysRenderNameTag;
    public final ModConfigSpec.BooleanValue workersAlwaysWorkInRain;
    public final ModConfigSpec.IntValue luckyBlockChance;
    public final ModConfigSpec.IntValue minThLevelToTeleport;
    public final ModConfigSpec.DoubleValue foodModifier;
    public final ModConfigSpec.IntValue diseaseModifier;
    public final ModConfigSpec.BooleanValue forceLoadColony;
    public final ModConfigSpec.IntValue loadtime;
    public final ModConfigSpec.IntValue colonyLoadStrictness;
    public final ModConfigSpec.IntValue maxTreeSize;
    public final ModConfigSpec.BooleanValue noSupplyPlacementRestrictions;
    public final ModConfigSpec.BooleanValue skyRaiders;
    public final ModConfigSpec.BooleanValue researchCreativeCompletion;
    public final ModConfigSpec.BooleanValue researchDebugLog;
    public final ModConfigSpec.ConfigValue<List<? extends String>> researchResetCost;
    public final ModConfigSpec.BooleanValue canPlayerUseRTPCommand;
    public final ModConfigSpec.BooleanValue canPlayerUseColonyTPCommand;
    public final ModConfigSpec.BooleanValue canPlayerUseAllyTHTeleport;
    public final ModConfigSpec.BooleanValue canPlayerUseHomeTPCommand;
    public final ModConfigSpec.BooleanValue canPlayerUseShowColonyInfoCommand;
    public final ModConfigSpec.BooleanValue canPlayerUseKillCitizensCommand;
    public final ModConfigSpec.BooleanValue canPlayerUseModifyCitizensCommand;
    public final ModConfigSpec.BooleanValue canPlayerUseAddOfficerCommand;
    public final ModConfigSpec.BooleanValue canPlayerUseDeleteColonyCommand;
    public final ModConfigSpec.BooleanValue canPlayerUseResetCommand;
    public final ModConfigSpec.IntValue maxColonySize;
    public final ModConfigSpec.IntValue minColonyDistance;
    public final ModConfigSpec.IntValue initialColonySize;
    public final ModConfigSpec.IntValue maxDistanceFromWorldSpawn;
    public final ModConfigSpec.IntValue minDistanceFromWorldSpawn;
    public final ModConfigSpec.BooleanValue enableColonyRaids;
    public final ModConfigSpec.IntValue raidDifficulty;
    public final ModConfigSpec.IntValue maxRaiders;
    public final ModConfigSpec.BooleanValue raidersbreakblocks;
    public final ModConfigSpec.IntValue averageNumberOfNightsBetweenRaids;
    public final ModConfigSpec.IntValue minimumNumberOfNightsBetweenRaids;
    public final ModConfigSpec.BooleanValue raidersbreakdoors;
    public final ModConfigSpec.BooleanValue mobAttackCitizens;
    public final ModConfigSpec.DoubleValue guardDamageMultiplier;
    public final ModConfigSpec.DoubleValue guardHealthMult;
    public final ModConfigSpec.BooleanValue pvp_mode;
    public final ModConfigSpec.BooleanValue enableColonyProtection;
    public final ModConfigSpec.EnumValue<Explosions> turnOffExplosionsInColonies;
    public final ModConfigSpec.BooleanValue auditCraftingTags;
    public final ModConfigSpec.BooleanValue debugInventories;
    public final ModConfigSpec.BooleanValue blueprintBuildMode;
    public final ModConfigSpec.IntValue pathfindingDebugVerbosity;
    public final ModConfigSpec.IntValue pathfindingMaxThreadCount;
    public final ModConfigSpec.IntValue minimumRailsToPath;
    public final ModConfigSpec.BooleanValue creativeResolve;
    public final ModConfigSpec.BooleanValue netherWorkerTakesDamage;

    public ServerConfiguration(ModConfigSpec.Builder builder) {
        super(builder, "minecolonies");
        Predicate<Object> stringValidator = s -> s instanceof String;
        this.createCategory("gameplay");
        this.initialCitizenAmount = this.defineInteger("initialcitizenamount", 4, 1, 10);
        this.allowInfiniteSupplyChests = this.defineBoolean("allowinfinitesupplychests", false);
        this.allowInfiniteColonies = this.defineBoolean("allowinfinitecolonies", false);
        this.allowOtherDimColonies = this.defineBoolean("allowotherdimcolonies", true);
        this.maxCitizenPerColony = this.defineInteger("maxcitizenpercolony", 250, 25, 500);
        this.enableInDevelopmentFeatures = this.defineBoolean("enableindevelopmentfeatures", false);
        this.alwaysRenderNameTag = this.defineBoolean("alwaysrendernametag", true);
        this.workersAlwaysWorkInRain = this.defineBoolean("workersalwaysworkinrain", false);
        this.luckyBlockChance = this.defineInteger("luckyblockchance", 1, 0, 100);
        this.minThLevelToTeleport = this.defineInteger("minthleveltoteleport", 3, 0, 5);
        this.foodModifier = this.defineDouble("foodmodifier", 1.0, 0.1, 100.0);
        this.diseaseModifier = this.defineInteger("diseasemodifier", 5, 1, 100);
        this.forceLoadColony = this.defineBoolean("forceloadcolony", true);
        this.loadtime = this.defineInteger("loadtime", 10, 1, 1440);
        this.colonyLoadStrictness = this.defineInteger("colonyloadstrictness", 3, 1, 15);
        this.maxTreeSize = this.defineInteger("maxtreesize", 400, 1, 1000);
        this.noSupplyPlacementRestrictions = this.defineBoolean("nosupplyplacementrestrictions", false);
        this.skyRaiders = this.defineBoolean("skyraiders", false);
        this.swapToCategory("research");
        this.researchCreativeCompletion = this.defineBoolean("researchcreativecompletion", true);
        this.researchDebugLog = this.defineBoolean("researchdebuglog", false);
        this.researchResetCost = this.defineList("researchresetcost", () -> "item ID, possibly with data", stringValidator, new String[]{"minecolonies:ancienttome:1"});
        this.swapToCategory("commands");
        this.canPlayerUseRTPCommand = this.defineBoolean("canplayerusertpcommand", false);
        this.canPlayerUseColonyTPCommand = this.defineBoolean("canplayerusecolonytpcommand", false);
        this.canPlayerUseAllyTHTeleport = this.defineBoolean("canplayeruseallytownhallteleport", true);
        this.canPlayerUseHomeTPCommand = this.defineBoolean("canplayerusehometpcommand", false);
        this.canPlayerUseShowColonyInfoCommand = this.defineBoolean("canplayeruseshowcolonyinfocommand", true);
        this.canPlayerUseKillCitizensCommand = this.defineBoolean("canplayerusekillcitizenscommand", false);
        this.canPlayerUseModifyCitizensCommand = this.defineBoolean("canplayerusemodifycitizenscommand", false);
        this.canPlayerUseAddOfficerCommand = this.defineBoolean("canplayeruseaddofficercommand", true);
        this.canPlayerUseDeleteColonyCommand = this.defineBoolean("canplayerusedeletecolonycommand", false);
        this.canPlayerUseResetCommand = this.defineBoolean("canplayeruseresetcommand", false);
        this.swapToCategory("claims");
        this.maxColonySize = this.defineInteger("maxColonySize", 20, 1, 250);
        this.minColonyDistance = this.defineInteger("minColonyDistance", 8, 1, 200);
        this.initialColonySize = this.defineInteger("initialColonySize", 4, 1, 15);
        this.maxDistanceFromWorldSpawn = this.defineInteger("maxdistancefromworldspawn", 30000, 1000, Integer.MAX_VALUE);
        this.minDistanceFromWorldSpawn = this.defineInteger("mindistancefromworldspawn", 0, 0, 1000);
        this.swapToCategory("combat");
        this.enableColonyRaids = this.defineBoolean("dobarbariansspawn", true);
        this.raidDifficulty = this.defineInteger("barbarianhordedifficulty", 5, 0, 10);
        this.maxRaiders = this.defineInteger("maxBarbarianSize", 80, 6, 400);
        this.raidersbreakblocks = this.defineBoolean("dobarbariansbreakthroughwalls", true);
        this.averageNumberOfNightsBetweenRaids = this.defineInteger("averagenumberofnightsbetweenraids", 14, 1, 50);
        this.minimumNumberOfNightsBetweenRaids = this.defineInteger("minimumnumberofnightsbetweenraids", 10, 1, 30);
        this.mobAttackCitizens = this.defineBoolean("mobattackcitizens", true);
        this.raidersbreakdoors = this.defineBoolean("shouldraiderbreakdoors", true);
        this.guardDamageMultiplier = this.defineDouble("guardDamageMultiplier", 1.0, 0.1, 15.0);
        this.guardHealthMult = this.defineDouble("guardhealthmult", 1.0, 0.1, 5.0);
        this.pvp_mode = this.defineBoolean("pvp_mode", false);
        this.swapToCategory("permissions");
        this.enableColonyProtection = this.defineBoolean("enablecolonyprotection", true);
        this.turnOffExplosionsInColonies = this.defineEnum("turnoffexplosionsincolonies", Explosions.DAMAGE_ENTITIES);
        this.swapToCategory("compatibility");
        this.auditCraftingTags = this.defineBoolean("auditcraftingtags", false);
        this.debugInventories = this.defineBoolean("debuginventories", false);
        this.blueprintBuildMode = this.defineBoolean("blueprintbuildmode", false);
        this.swapToCategory("pathfinding");
        this.pathfindingDebugVerbosity = this.defineInteger("pathfindingdebugverbosity", 0, 0, 10);
        this.minimumRailsToPath = this.defineInteger("minimumrailstopath", 8, 5, 100);
        this.pathfindingMaxThreadCount = this.defineInteger("pathfindingmaxthreadcount", 1, 1, 10);
        this.swapToCategory("requestSystem");
        this.creativeResolve = this.defineBoolean("creativeresolve", false);
        this.swapToCategory("debugging");
        this.netherWorkerTakesDamage = this.defineBoolean("netherworkertakesdamage", true);
        this.finishCategory();
    }
}

