/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.AbstractRecipeType;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRecipeStorage {
    public List<ItemStorage> getInput();

    public List<ItemStorage> getCleanedInput();

    public ItemStack getPrimaryOutput();

    public int getGridSize();

    public Block getIntermediate();

    public boolean canFullFillRecipe(int var1, Map<ItemStorage, Integer> var2, IItemHandler ... var3);

    public boolean canFullFillRecipe(int var1, Map<ItemStorage, Integer> var2, @NotNull List<IItemHandler> var3, @NotNull IBuilding var4);

    default public boolean fullFillRecipe(@NotNull Level world, IItemHandler ... inventories) {
        return this.fullfillRecipe(world, Arrays.asList(inventories));
    }

    default public boolean fullFillRecipe(@NotNull LootParams context, IItemHandler ... inventories) {
        return this.fullfillRecipe(context, Arrays.asList(inventories));
    }

    default public boolean fullfillRecipe(LootParams context, List<IItemHandler> handlers) {
        return this.fullfillRecipeAndCopy(context, handlers, true) != null;
    }

    default public boolean fullfillRecipe(Level world, List<IItemHandler> handlers) {
        return this.fullfillRecipeAndCopy(world, handlers, true) != null;
    }

    @Nullable
    public List<ItemStack> fullfillRecipeAndCopy(LootParams var1, List<IItemHandler> var2, boolean var3);

    @Nullable
    default public List<ItemStack> fullfillRecipeAndCopy(Level world, List<IItemHandler> handlers, boolean doInsert) {
        return this.fullfillRecipeAndCopy(new LootParams.Builder((ServerLevel)world).create(LootContextParamSets.EMPTY), handlers, doInsert);
    }

    public AbstractRecipeType<IRecipeStorage> getRecipeType();

    public List<ItemStack> getAlternateOutputs();

    public RecipeStorage getClassicForMultiOutput(ItemStack var1);

    public RecipeStorage getClassicForMultiOutput(Predicate<ItemStack> var1);

    public ResourceLocation getRecipeSource();

    public List<ItemStack> getSecondaryOutputs();

    public List<ItemStack> getCraftingToolsAndSecondaryOutputs();

    public List<ItemStack> getCraftingTools();

    public EquipmentTypeEntry getRequiredTool();

    public ResourceKey<LootTable> getLootTable();

    public IToken<?> getToken();
}

