/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs.vikings;

import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityNorsemenRaider
extends AbstractEntityMinecoloniesRaider {
    private static final double PIRATE_SWIM_BONUS = 2.3;
    private static final int NORSEMEN_TEXTURES = 3;

    public AbstractEntityNorsemenRaider(EntityType<? extends AbstractEntityNorsemenRaider> type, Level world) {
        super((EntityType<? extends AbstractEntityMinecoloniesRaider>)type, world, 3);
    }

    @Override
    public void playAmbientSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null && this.level().random.nextInt(100) <= 1) {
            this.playSound(soundevent, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.1f + 1.0f;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    @Override
    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        AbstractAdvancedPathNavigate navigator = super.getNavigation();
        navigator.getPathingOptions().withStartSwimCost(2.5).withSwimCost(1.1);
        return navigator;
    }

    @Override
    public RaiderType getRaiderType() {
        return RaiderType.NORSEMAN;
    }

    @Override
    public double getSwimSpeedFactor() {
        return 2.3;
    }
}

