/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.items.component;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.items.component.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ColonyId(int id, ResourceKey<Level> dimension) implements TooltipProvider
{
    public static final ColonyId EMPTY = new ColonyId(-1, (ResourceKey<Level>)Level.OVERWORLD);
    public static final Codec<ColonyId> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("id").forGetter(ColonyId::id), (App)Level.RESOURCE_KEY_CODEC.fieldOf("dimension").forGetter(ColonyId::dimension)).apply((Applicative)builder, ColonyId::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ColonyId> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ColonyId::id, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), ColonyId::dimension, ColonyId::new);

    public boolean hasColonyId() {
        return this.id != ColonyId.EMPTY.id;
    }

    public void writeToItemStack(ItemStack itemStack) {
        itemStack.set(ModDataComponents.COLONY_ID_COMPONENT, (Object)this);
    }

    public static ColonyId readFromItemStack(ItemStack itemStack) {
        return (ColonyId)itemStack.getOrDefault(ModDataComponents.COLONY_ID_COMPONENT, (Object)EMPTY);
    }

    @Nullable
    public static IColony readColonyFromItemStack(ItemStack itemStack) {
        ColonyId colonyId = ColonyId.readFromItemStack(itemStack);
        return colonyId == EMPTY ? null : IColonyManager.getInstance().getColonyByDimension(colonyId.id(), colonyId.dimension());
    }

    @Nullable
    public static IColonyView readColonyViewFromItemStack(ItemStack itemStack) {
        ColonyId colonyId = ColonyId.readFromItemStack(itemStack);
        return colonyId == EMPTY ? null : IColonyManager.getInstance().getColonyView(colonyId.id(), colonyId.dimension());
    }

    public static void updateItemStack(ItemStack itemStack, UnaryOperator<ColonyId> updater) {
        ((ColonyId)updater.apply(ColonyId.readFromItemStack(itemStack))).writeToItemStack(itemStack);
    }

    public void addToTooltip(@NotNull Item.TooltipContext context, @NotNull Consumer<Component> tooltip, @NotNull TooltipFlag flags) {
        IColonyView colony = IMinecoloniesAPI.getInstance().getColonyManager().getColonyView(this.id(), this.dimension());
        MutableComponent name = colony != null ? Component.literal((String)colony.getName()) : Component.translatable((String)"item.minecolonies.hut.unknowncolony");
        tooltip.accept((Component)Component.translatable((String)"item.minecolonies.hut.colony", (Object[])new Object[]{name}).withStyle(ChatFormatting.ITALIC));
    }
}

