/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.quests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.quests.registries.QuestRegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface IDialogueObjectiveTemplate
extends IQuestObjectiveTemplate {
    public DialogueElement getDialogueTree();

    public static class AnswerElement {
        private final Component text;
        private final IQuestDialogueAnswer answerResult;

        public AnswerElement(Component text, IQuestDialogueAnswer answerResult) {
            this.text = text;
            this.answerResult = answerResult;
        }

        public static AnswerElement parse(JsonObject jsonObject) {
            JsonObject resultObj = jsonObject.getAsJsonObject("result");
            return new AnswerElement((Component)Component.translatableEscape((String)jsonObject.get("answer").getAsString(), (Object[])new Object[0]), ((QuestRegistries.DialogueAnswerEntry)IMinecoloniesAPI.getInstance().getQuestDialogueAnswerRegistry().get(ResourceLocation.parse((String)resultObj.get("type").getAsString()))).produce(resultObj));
        }
    }

    public static class DialogueElement
    implements IQuestDialogueAnswer {
        private final Component text;
        private final List<AnswerElement> answers;

        public DialogueElement(Component text, List<AnswerElement> answers) {
            this.text = text;
            this.answers = answers;
        }

        public static DialogueElement parse(JsonObject jsonObject) {
            MutableComponent text = Component.translatableEscape((String)jsonObject.get("text").getAsString(), (Object[])new Object[0]);
            ArrayList<AnswerElement> answerElementList = new ArrayList<AnswerElement>();
            for (JsonElement answerOption : jsonObject.getAsJsonArray("options")) {
                answerElementList.add(AnswerElement.parse(answerOption.getAsJsonObject()));
            }
            return new DialogueElement((Component)text, answerElementList);
        }

        public Component getText() {
            return this.text;
        }

        public List<Component> getOptions() {
            return this.answers.stream().map(answerElement -> answerElement.text).collect(Collectors.toList());
        }

        @Nullable
        public IQuestDialogueAnswer getOptionResult(int responseId) {
            return responseId < this.answers.size() ? this.answers.get((int)responseId).answerResult : null;
        }
    }
}

