/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BlockStateUtils {
    private static final Map<String, Property<?>> propertyBlockMap = new HashMap();

    private BlockStateUtils() {
    }

    public static boolean stateEqualsStateByBlockAndProp(@NotNull BlockState state1, @NotNull BlockState state2, @NotNull String propertyName) {
        if (state1.getBlock() != state2.getBlock()) {
            return false;
        }
        if (BlockStateUtils.stateEqualsStateInPropertyByName(state1, state2, propertyName)) {
            return true;
        }
        return state1 == state2;
    }

    public static boolean stateEqualsStateInPropertyByName(@NotNull BlockState state1, @NotNull BlockState state2, @NotNull String propertyName) {
        Property<?> propertyOne = BlockStateUtils.getPropertyByNameFromState(state1, propertyName);
        if (propertyOne != null && state2.hasProperty(propertyOne)) {
            return state1.getValue(propertyOne) == state2.getValue(propertyOne);
        }
        Property<?> propertyTwo = BlockStateUtils.getPropertyByNameFromState(state2, propertyName);
        if (propertyOne != null && propertyTwo != null && state1.hasProperty(propertyOne) && state2.hasProperty(propertyTwo)) {
            return state1.getValue(propertyOne).toString().equals(state2.getValue(propertyTwo).toString());
        }
        return false;
    }

    public static Property<?> getPropertyByNameFromState(@NotNull BlockState state, @NotNull String name) {
        Property<?> property = propertyBlockMap.get(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString() + ":" + name);
        if (property != null && state.hasProperty(property)) {
            return property;
        }
        property = BlockStateUtils.getPropertyByName(state.getProperties(), name);
        if (property != null) {
            propertyBlockMap.put(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString() + ":" + name, property);
        }
        return property;
    }

    public static Property<?> getPropertyByName(@NotNull Collection<Property<?>> properties, @NotNull String name) {
        for (Property<?> tProperty : properties) {
            if (!tProperty.getName().equals(name)) continue;
            return tProperty;
        }
        return null;
    }

    public static <T extends Comparable<T>> boolean stateEqualsStateWithoutProp(@NotNull BlockState state1, @NotNull BlockState state2, @NotNull Property<T> prop) {
        if (!state1.hasProperty(prop) || !state2.hasProperty(prop)) {
            return state1 == state2;
        }
        return state1.setValue(prop, state2.getValue(prop)) == state2;
    }

    public static boolean stateEqualsStateInBlockAndProp(BlockState state1, BlockState state2) {
        if (state1 == null || state2 == null) {
            return false;
        }
        if (state1.getBlock() != state2.getBlock()) {
            return false;
        }
        if (state1.getProperties().size() != state2.getProperties().size()) {
            return false;
        }
        for (Property prop : state1.getProperties()) {
            if (!state2.hasProperty(prop)) {
                return false;
            }
            if (state1.getValue(prop) == state2.getValue(prop)) continue;
            return false;
        }
        return true;
    }
}

